/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.item.custom.ItemDefinition;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.network.protocol.DataPacket;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.List;
import lombok.Generated;

public class ItemComponentPacket
extends DataPacket {
    public static final byte NETWORK_ID = -94;
    public List<ItemDefinition> itemDefinitions;

    @Override
    public byte pid() {
        return -94;
    }

    @Override
    public void decode() {
        this.decodeUnsupported();
    }

    @Override
    public void encode() {
        this.reset();
        this.putUnsignedVarInt(this.itemDefinitions.size());
        for (ItemDefinition definition : this.itemDefinitions) {
            this.putString(definition.getIdentifier());
            try {
                this.put(NBTIO.write(definition.getNetworkData(), ByteOrder.LITTLE_ENDIAN, true));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Generated
    public String toString() {
        return "ItemComponentPacket(itemDefinitions=" + this.itemDefinitions + ")";
    }
}

