/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.item.Item;
import cn.nukkit.network.protocol.DataPacket;
import java.util.Arrays;
import lombok.Generated;

public class InventoryContentPacket
extends DataPacket {
    public static final byte NETWORK_ID = 49;
    public static final int SPECIAL_INVENTORY = 0;
    public static final int SPECIAL_OFFHAND = 119;
    public static final int SPECIAL_ARMOR = 120;
    public static final int SPECIAL_CREATIVE = 121;
    public static final int SPECIAL_HOTBAR = 122;
    public static final int SPECIAL_FIXED_INVENTORY = 123;
    private static final Item EMPTY_STORAGE_ITEM = Item.get(0);
    public int inventoryId;
    public int networkId;
    public Item[] slots = new Item[0];

    @Override
    public byte pid() {
        return 49;
    }

    @Override
    public DataPacket clean() {
        this.slots = new Item[0];
        return super.clean();
    }

    @Override
    public void decode() {
        this.decodeUnsupported();
    }

    @Override
    public void encode() {
        this.reset();
        this.putUnsignedVarInt(this.inventoryId);
        this.putUnsignedVarInt(this.slots.length);
        for (Item slot : this.slots) {
            this.putSlot(slot);
        }
        this.putByte((byte)0);
        this.putBoolean(false);
        this.putSlot(EMPTY_STORAGE_ITEM);
    }

    @Generated
    public String toString() {
        return "InventoryContentPacket(inventoryId=" + this.inventoryId + ", networkId=" + this.networkId + ", slots=" + Arrays.deepToString(this.slots) + ")";
    }
}

