/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.network.protocol.DataPacket;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

public class EmoteListPacket
extends DataPacket {
    public static final byte NETWORK_ID = -104;
    public long runtimeId;
    public final List<UUID> pieceIds = new ObjectArrayList<UUID>();

    @Override
    public byte pid() {
        return -104;
    }

    @Override
    public void decode() {
        this.runtimeId = this.getEntityRuntimeId();
        int size = (int)this.getUnsignedVarInt();
        if (size > 1000) {
            throw new RuntimeException("Too big EmoteListPacket: " + size);
        }
        for (int i = 0; i < size; ++i) {
            UUID id = this.getUUID();
            this.pieceIds.add(id);
        }
    }

    @Override
    public void encode() {
        this.reset();
        this.putEntityRuntimeId(this.runtimeId);
        this.putUnsignedVarInt(this.pieceIds.size());
        for (UUID id : this.pieceIds) {
            this.putUUID(id);
        }
    }

    @Generated
    public String toString() {
        return "EmoteListPacket(runtimeId=" + this.runtimeId + ", pieceIds=" + this.pieceIds + ")";
    }
}

