/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.inventory.BrewingRecipe;
import cn.nukkit.inventory.ContainerRecipe;
import cn.nukkit.inventory.FurnaceRecipe;
import cn.nukkit.inventory.MultiRecipe;
import cn.nukkit.inventory.Recipe;
import cn.nukkit.inventory.RecipeType;
import cn.nukkit.inventory.ShapedRecipe;
import cn.nukkit.inventory.ShapelessRecipe;
import cn.nukkit.inventory.SmithingRecipe;
import cn.nukkit.item.Item;
import cn.nukkit.network.protocol.DataPacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class CraftingDataPacket
extends DataPacket {
    public static final byte NETWORK_ID = 52;
    public static final String CRAFTING_TAG_CRAFTING_TABLE = "crafting_table";
    public static final String CRAFTING_TAG_CARTOGRAPHY_TABLE = "cartography_table";
    public static final String CRAFTING_TAG_STONECUTTER = "stonecutter";
    public static final String CRAFTING_TAG_FURNACE = "furnace";
    public static final String CRAFTING_TAG_CAMPFIRE = "campfire";
    public static final String CRAFTING_TAG_BLAST_FURNACE = "blast_furnace";
    public static final String CRAFTING_TAG_SMOKER = "smoker";
    public static final String CRAFTING_TAG_SMITHING_TABLE = "smithing_table";
    private List<Recipe> entries = new ArrayList<Recipe>();
    private final List<BrewingRecipe> brewingEntries = new ArrayList<BrewingRecipe>();
    private final List<ContainerRecipe> containerEntries = new ArrayList<ContainerRecipe>();
    public boolean cleanRecipes = true;

    public void addShapelessRecipe(ShapelessRecipe ... recipe) {
        Collections.addAll(this.entries, recipe);
    }

    public void addShapedRecipe(ShapedRecipe ... recipe) {
        Collections.addAll(this.entries, recipe);
    }

    public void addFurnaceRecipe(FurnaceRecipe ... recipe) {
        Collections.addAll(this.entries, recipe);
    }

    public void addBrewingRecipe(BrewingRecipe ... recipe) {
        Collections.addAll(this.brewingEntries, recipe);
    }

    public void addMultiRecipe(MultiRecipe ... recipe) {
        Collections.addAll(this.entries, recipe);
    }

    public void addContainerRecipe(ContainerRecipe ... recipe) {
        Collections.addAll(this.containerEntries, recipe);
    }

    @Override
    public DataPacket clean() {
        this.entries = new ArrayList<Recipe>();
        return super.clean();
    }

    @Override
    public void decode() {
        this.decodeUnsupported();
    }

    @Override
    public void encode() {
        this.reset();
        this.putUnsignedVarInt(this.entries.size());
        for (Recipe recipe : this.entries) {
            RecipeType networkType = recipe.getType();
            if (networkType == RecipeType.SMITHING_TRANSFORM) {
                networkType = RecipeType.REPAIR;
            }
            this.putVarInt(networkType.ordinal());
            switch (recipe.getType()) {
                case SHAPELESS: {
                    ShapelessRecipe shapeless = (ShapelessRecipe)recipe;
                    this.putString(shapeless.getRecipeId());
                    List<Item> ingredients = shapeless.getIngredientList();
                    this.putUnsignedVarInt(ingredients.size());
                    for (Item ingredient : ingredients) {
                        this.putRecipeIngredient(ingredient);
                    }
                    this.putUnsignedVarInt(1L);
                    this.putSlot(shapeless.getResult(), true);
                    this.putUUID(shapeless.getId());
                    this.putString(CRAFTING_TAG_CRAFTING_TABLE);
                    this.putVarInt(shapeless.getPriority());
                    this.putByte((byte)1);
                    this.putUnsignedVarInt(shapeless.getNetworkId());
                    break;
                }
                case SHAPED: {
                    ShapedRecipe shaped = (ShapedRecipe)recipe;
                    this.putString(shaped.getRecipeId());
                    this.putVarInt(shaped.getWidth());
                    this.putVarInt(shaped.getHeight());
                    for (int z = 0; z < shaped.getHeight(); ++z) {
                        for (int x = 0; x < shaped.getWidth(); ++x) {
                            this.putRecipeIngredient(shaped.getIngredient(x, z));
                        }
                    }
                    ArrayList<Item> outputs = new ArrayList<Item>();
                    outputs.add(shaped.getResult());
                    outputs.addAll(shaped.getExtraResults());
                    this.putUnsignedVarInt(outputs.size());
                    for (Item output : outputs) {
                        this.putSlot(output, true);
                    }
                    this.putUUID(shaped.getId());
                    this.putString(CRAFTING_TAG_CRAFTING_TABLE);
                    this.putVarInt(shaped.getPriority());
                    this.putBoolean(true);
                    this.putByte((byte)1);
                    this.putUnsignedVarInt(shaped.getNetworkId());
                    break;
                }
                case FURNACE: 
                case FURNACE_DATA: {
                    FurnaceRecipe furnace = (FurnaceRecipe)recipe;
                    Item input = furnace.getInput();
                    this.putVarInt(input.getId());
                    if (recipe.getType() == RecipeType.FURNACE_DATA) {
                        this.putVarInt(input.getDamage());
                    }
                    this.putSlot(furnace.getResult(), true);
                    this.putString(CRAFTING_TAG_FURNACE);
                    break;
                }
                case MULTI: {
                    this.putUUID(((MultiRecipe)recipe).getId());
                    this.putUnsignedVarInt(((MultiRecipe)recipe).getNetworkId());
                    break;
                }
                case SHULKER_BOX: {
                    break;
                }
                case SHAPELESS_CHEMISTRY: {
                    break;
                }
                case SHAPED_CHEMISTRY: {
                    break;
                }
                case REPAIR: {
                    break;
                }
                case CAMPFIRE: {
                    break;
                }
                case CAMPFIRE_DATA: {
                    break;
                }
                case SMITHING_TRANSFORM: {
                    SmithingRecipe smithing = (SmithingRecipe)recipe;
                    this.putString(smithing.getRecipeId());
                    this.putRecipeIngredient(Item.get(0));
                    this.putRecipeIngredient(smithing.getEquipment());
                    this.putRecipeIngredient(smithing.getIngredient());
                    this.putSlot(smithing.getResult(), true);
                    this.putString(CRAFTING_TAG_SMITHING_TABLE);
                    this.putUnsignedVarInt(smithing.getNetworkId());
                }
            }
        }
        this.putUnsignedVarInt(this.brewingEntries.size());
        for (BrewingRecipe brewingRecipe : this.brewingEntries) {
            this.putVarInt(brewingRecipe.getInput().getNetworkId());
            this.putVarInt(brewingRecipe.getInput().getDamage());
            this.putVarInt(brewingRecipe.getIngredient().getNetworkId());
            this.putVarInt(brewingRecipe.getIngredient().getDamage());
            this.putVarInt(brewingRecipe.getResult().getNetworkId());
            this.putVarInt(brewingRecipe.getResult().getDamage());
        }
        this.putUnsignedVarInt(this.containerEntries.size());
        for (ContainerRecipe containerRecipe : this.containerEntries) {
            this.putVarInt(containerRecipe.getInput().getNetworkId());
            this.putVarInt(containerRecipe.getIngredient().getNetworkId());
            this.putVarInt(containerRecipe.getResult().getNetworkId());
        }
        this.putUnsignedVarInt(0L);
        this.putBoolean(this.cleanRecipes);
    }

    @Override
    public byte pid() {
        return 52;
    }

    @Generated
    public String toString() {
        return "CraftingDataPacket(entries=" + this.entries + ", brewingEntries=" + this.brewingEntries + ", containerEntries=" + this.containerEntries + ", cleanRecipes=" + this.cleanRecipes + ")";
    }
}

