/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.math.BlockVector3;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.utils.Utils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import lombok.Generated;

public class ClientboundMapItemDataPacket
extends DataPacket {
    public static final byte NETWORK_ID = 67;
    public long mapId;
    public int update;
    public byte scale;
    public boolean isLocked;
    public int width;
    public int height;
    public int offsetX;
    public int offsetZ;
    public byte dimensionId;
    public BlockVector3 origin = EMPTY_BlockVector3;
    public MapDecorator[] decorators = EMPTY_MapDecorator;
    public MapTrackedObject[] trackedEntities = EMPTY_MapTrackedObject;
    public long[] eids = EMPTY_long;
    public int[] colors = EMPTY_int;
    public BufferedImage image;
    private static final BlockVector3 EMPTY_BlockVector3 = new BlockVector3();
    private static final MapDecorator[] EMPTY_MapDecorator = new MapDecorator[0];
    private static final MapTrackedObject[] EMPTY_MapTrackedObject = new MapTrackedObject[0];
    private static final long[] EMPTY_long = new long[0];
    private static final int[] EMPTY_int = new int[0];
    public static final int TEXTURE_UPDATE = 2;
    public static final int DECORATIONS_UPDATE = 4;
    public static final int ENTITIES_UPDATE = 8;

    @Override
    public byte pid() {
        return 67;
    }

    @Override
    public void decode() {
        this.decodeUnsupported();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void encode() {
        this.reset();
        this.putEntityUniqueId(this.mapId);
        int update = 0;
        if (this.eids.length > 0) {
            update |= 8;
        }
        if (this.decorators.length > 0) {
            update |= 4;
        }
        if (this.image != null || this.colors.length > 0) {
            update |= 2;
        }
        this.putUnsignedVarInt(update);
        this.putByte(this.dimensionId);
        this.putBoolean(this.isLocked);
        this.putSignedBlockPosition(this.origin);
        if ((update & 8) != 0) {
            this.putUnsignedVarInt(this.eids.length);
            for (long eid : this.eids) {
                this.putEntityUniqueId(eid);
            }
        }
        if ((update & 0xE) != 0) {
            this.putByte(this.scale);
        }
        if ((update & 4) != 0) {
            this.putUnsignedVarInt(this.trackedEntities.length);
            for (MapTrackedObject object : this.trackedEntities) {
                this.putLInt(object.type);
                if (object.type == 1) {
                    this.putBlockVector3(object.x, object.y, object.z);
                    continue;
                }
                if (object.type == 0) {
                    this.putEntityUniqueId(object.entityUniqueId);
                    continue;
                }
                throw new IllegalArgumentException("Unknown map object type " + object.type);
            }
            this.putUnsignedVarInt(this.decorators.length);
            for (MapDecorator decorator : this.decorators) {
                this.putByte(decorator.icon);
                this.putByte(decorator.rotation);
                this.putByte(decorator.offsetX);
                this.putByte(decorator.offsetZ);
                this.putString(decorator.label);
                this.putUnsignedVarInt(decorator.color.getRGB());
            }
        }
        if ((update & 2) != 0) {
            this.putVarInt(this.width);
            this.putVarInt(this.height);
            this.putVarInt(this.offsetX);
            this.putVarInt(this.offsetZ);
            this.putUnsignedVarInt((long)this.width * (long)this.height);
            if (this.image != null) {
                void var2_7;
                boolean bl = false;
                while (var2_7 < this.width) {
                    for (int x = 0; x < this.height; ++x) {
                        this.putUnsignedVarInt(Utils.toABGR(this.image.getRGB(x, (int)var2_7)));
                    }
                    ++var2_7;
                }
                this.image.flush();
            } else {
                for (int color : this.colors) {
                    this.putUnsignedVarInt(color);
                }
            }
        }
    }

    @Generated
    public String toString() {
        return "ClientboundMapItemDataPacket(mapId=" + this.mapId + ", update=" + this.update + ", scale=" + this.scale + ", isLocked=" + this.isLocked + ", width=" + this.width + ", height=" + this.height + ", offsetX=" + this.offsetX + ", offsetZ=" + this.offsetZ + ", dimensionId=" + this.dimensionId + ", origin=" + this.origin + ", decorators=" + Arrays.deepToString(this.decorators) + ", trackedEntities=" + Arrays.deepToString(this.trackedEntities) + ", eids=" + Arrays.toString(this.eids) + ", colors=" + Arrays.toString(this.colors) + ", image=" + this.image + ")";
    }

    public static class MapTrackedObject {
        public static final int TYPE_ENTITY = 0;
        public static final int TYPE_BLOCK = 1;
        public int type;
        public long entityUniqueId;
        public int x;
        public int y;
        public int z;
    }

    public static class MapDecorator {
        public byte rotation;
        public byte icon;
        public byte offsetX;
        public byte offsetZ;
        public String label;
        public Color color;
    }
}

