/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.encryption;

import cn.nukkit.Player;
import cn.nukkit.network.encryption.EncryptionUtils;
import cn.nukkit.scheduler.AsyncTask;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.spec.ECGenParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import lombok.Generated;

public class PrepareEncryptionTask
extends AsyncTask {
    private final Player player;
    private String handshakeJwt;
    private SecretKey encryptionKey;
    private Cipher encryptionCipher;
    private Cipher decryptionCipher;

    public PrepareEncryptionTask(Player player) {
        this.player = player;
    }

    @Override
    public void onRun() {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("EC");
            generator.initialize(new ECGenParameterSpec("secp384r1"));
            KeyPair serverKeyPair = generator.generateKeyPair();
            byte[] token = EncryptionUtils.generateRandomToken();
            this.encryptionKey = EncryptionUtils.getSecretKey(serverKeyPair.getPrivate(), EncryptionUtils.generateKey(this.player.getLoginChainData().getIdentityPublicKey()), token);
            this.handshakeJwt = EncryptionUtils.createHandshakeJwt(serverKeyPair, token).serialize();
            this.encryptionCipher = EncryptionUtils.createCipher(true, true, this.encryptionKey);
            this.decryptionCipher = EncryptionUtils.createCipher(true, false, this.encryptionKey);
        }
        catch (Exception ex) {
            this.player.getServer().getLogger().error("Exception in PrepareEncryptionTask", ex);
        }
    }

    @Generated
    public String getHandshakeJwt() {
        return this.handshakeJwt;
    }

    @Generated
    public SecretKey getEncryptionKey() {
        return this.encryptionKey;
    }

    @Generated
    public Cipher getEncryptionCipher() {
        return this.encryptionCipher;
    }

    @Generated
    public Cipher getDecryptionCipher() {
        return this.decryptionCipher;
    }
}

