/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network;

import cn.nukkit.Nukkit;
import cn.nukkit.Server;
import cn.nukkit.network.AdvancedSourceInterface;
import cn.nukkit.network.CompressionProvider;
import cn.nukkit.network.SourceInterface;
import cn.nukkit.network.protocol.AnimatePacket;
import cn.nukkit.network.protocol.AnvilDamagePacket;
import cn.nukkit.network.protocol.BatchPacket;
import cn.nukkit.network.protocol.BlockEntityDataPacket;
import cn.nukkit.network.protocol.BlockPickRequestPacket;
import cn.nukkit.network.protocol.BookEditPacket;
import cn.nukkit.network.protocol.BossEventPacket;
import cn.nukkit.network.protocol.ClientToServerHandshakePacket;
import cn.nukkit.network.protocol.CommandRequestPacket;
import cn.nukkit.network.protocol.ContainerClosePacket;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.DisconnectPacket;
import cn.nukkit.network.protocol.EmoteListPacket;
import cn.nukkit.network.protocol.EmotePacket;
import cn.nukkit.network.protocol.EntityEventPacket;
import cn.nukkit.network.protocol.GUIDataPickItemPacket;
import cn.nukkit.network.protocol.InteractPacket;
import cn.nukkit.network.protocol.InventoryTransactionPacket;
import cn.nukkit.network.protocol.LecternUpdatePacket;
import cn.nukkit.network.protocol.LevelSoundEventPacket;
import cn.nukkit.network.protocol.LoginPacket;
import cn.nukkit.network.protocol.MapCreateLockedCopyPacket;
import cn.nukkit.network.protocol.MapInfoRequestPacket;
import cn.nukkit.network.protocol.MobArmorEquipmentPacket;
import cn.nukkit.network.protocol.MobEquipmentPacket;
import cn.nukkit.network.protocol.ModalFormResponsePacket;
import cn.nukkit.network.protocol.MoveEntityAbsolutePacket;
import cn.nukkit.network.protocol.NPCRequestPacket;
import cn.nukkit.network.protocol.NetworkSettingsPacket;
import cn.nukkit.network.protocol.NetworkStackLatencyPacket;
import cn.nukkit.network.protocol.PacketViolationWarningPacket;
import cn.nukkit.network.protocol.PlayerActionPacket;
import cn.nukkit.network.protocol.PlayerAuthInputPacket;
import cn.nukkit.network.protocol.PlayerHotbarPacket;
import cn.nukkit.network.protocol.PlayerInputPacket;
import cn.nukkit.network.protocol.PlayerSkinPacket;
import cn.nukkit.network.protocol.RequestAbilityPacket;
import cn.nukkit.network.protocol.RequestChunkRadiusPacket;
import cn.nukkit.network.protocol.RequestNetworkSettingsPacket;
import cn.nukkit.network.protocol.RequestPermissionsPacket;
import cn.nukkit.network.protocol.ResourcePackChunkRequestPacket;
import cn.nukkit.network.protocol.ResourcePackClientResponsePacket;
import cn.nukkit.network.protocol.RespawnPacket;
import cn.nukkit.network.protocol.RiderJumpPacket;
import cn.nukkit.network.protocol.ServerSettingsRequestPacket;
import cn.nukkit.network.protocol.SetDefaultGameTypePacket;
import cn.nukkit.network.protocol.SetDifficultyPacket;
import cn.nukkit.network.protocol.SetEntityLinkPacket;
import cn.nukkit.network.protocol.SetEntityMotionPacket;
import cn.nukkit.network.protocol.SetLocalPlayerAsInitializedPacket;
import cn.nukkit.network.protocol.SetPlayerGameTypePacket;
import cn.nukkit.network.protocol.SettingsCommandPacket;
import cn.nukkit.network.protocol.TextPacket;
import cn.nukkit.utils.BinaryStream;
import cn.nukkit.utils.Utils;
import cn.nukkit.utils.VarInt;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Network {
    @Generated
    private static final Logger log = LogManager.getLogger(Network.class);
    private Class<? extends DataPacket>[] packetPool = new Class[256];
    private final Server server;
    private final Set<SourceInterface> interfaces = new HashSet<SourceInterface>();
    private final Set<AdvancedSourceInterface> advancedInterfaces = new HashSet<AdvancedSourceInterface>();
    private double upload;
    private double download;
    private String name;
    private String subName;

    public Network(Server server) {
        this.registerPackets();
        this.server = server;
    }

    @Deprecated
    public void addStatistics(double upload, double download) {
        this.upload += upload;
        this.download += download;
    }

    @Deprecated
    public double getUpload() {
        return this.upload;
    }

    @Deprecated
    public double getDownload() {
        return this.download;
    }

    @Deprecated
    public void resetStatistics() {
        this.upload = 0.0;
        this.download = 0.0;
    }

    public Set<SourceInterface> getInterfaces() {
        return this.interfaces;
    }

    public void processInterfaces() {
        for (SourceInterface interfaz : this.interfaces) {
            try {
                interfaz.process();
            }
            catch (Exception e) {
                interfaz.emergencyShutdown();
                this.unregisterInterface(interfaz);
                log.fatal(this.server.getLanguage().translateString("nukkit.server.networkError", new String[]{interfaz.getClass().getName(), Utils.getExceptionMessage(e)}), (Throwable)e);
            }
        }
    }

    public void registerInterface(SourceInterface interfaz) {
        this.interfaces.add(interfaz);
        if (interfaz instanceof AdvancedSourceInterface) {
            this.advancedInterfaces.add((AdvancedSourceInterface)interfaz);
            ((AdvancedSourceInterface)interfaz).setNetwork(this);
        }
        interfaz.setName(this.name + "!@#" + this.subName);
    }

    public void unregisterInterface(SourceInterface sourceInterface) {
        this.interfaces.remove(sourceInterface);
        if (sourceInterface instanceof AdvancedSourceInterface) {
            this.advancedInterfaces.remove(sourceInterface);
        }
    }

    public void setName(String name) {
        this.name = name;
        this.updateName();
    }

    public String getName() {
        return this.name;
    }

    public String getSubName() {
        return this.subName;
    }

    public void setSubName(String subName) {
        this.subName = subName;
    }

    public void updateName() {
        for (SourceInterface interfaz : this.interfaces) {
            interfaz.setName(this.name + "!@#" + this.subName);
        }
    }

    public void registerPacket(byte id, Class<? extends DataPacket> clazz) {
        this.packetPool[id & 0xFF] = clazz;
    }

    public Server getServer() {
        return this.server;
    }

    public void processBatch(byte[] payload, Collection<DataPacket> packets, CompressionProvider compression) throws Exception {
        byte[] data = compression.decompress(payload, 0x600000);
        BinaryStream stream = new BinaryStream(data);
        int count = 0;
        while (!stream.feof()) {
            if (++count > 1300) {
                throw new ProtocolException("Too big batch packet (count > 1300)");
            }
            byte[] buf = stream.getByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
            int packetId = (int)VarInt.readUnsignedVarInt(bais) & 0x3FF;
            DataPacket pk = this.getPacket(packetId >= 300 ? packetId - 100 : packetId);
            if (pk == null) {
                if (Nukkit.DEBUG <= 1) continue;
                log.debug("Received unknown packet with ID: 0x{}", (Object)Integer.toHexString(packetId));
                continue;
            }
            pk.setBuffer(buf, buf.length - bais.available());
            try {
                pk.decode();
                if (Nukkit.DEBUG > 1 && pk.offset < pk.getRawBuffer().length) {
                    log.debug(pk.getClass().getSimpleName() + " still has " + (pk.getRawBuffer().length - pk.offset) + " bytes to read!");
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to decode " + pk.getClass().getSimpleName(), e);
            }
            packets.add(pk);
        }
    }

    public DataPacket getPacket(int id) {
        Class<? extends DataPacket> clazz = this.packetPool[id];
        if (clazz != null) {
            try {
                return clazz.newInstance();
            }
            catch (Exception e) {
                Server.getInstance().getLogger().logException(e);
            }
        }
        return null;
    }

    public void sendPacket(InetSocketAddress socketAddress, ByteBuf payload) {
        for (AdvancedSourceInterface sourceInterface : this.advancedInterfaces) {
            sourceInterface.sendRawPacket(socketAddress, payload);
        }
    }

    public void blockAddress(InetAddress address) {
        for (AdvancedSourceInterface sourceInterface : this.advancedInterfaces) {
            sourceInterface.blockAddress(address);
        }
    }

    public void blockAddress(InetAddress address, int timeout) {
        for (AdvancedSourceInterface sourceInterface : this.advancedInterfaces) {
            sourceInterface.blockAddress(address, timeout);
        }
    }

    public void unblockAddress(InetAddress address) {
        for (AdvancedSourceInterface sourceInterface : this.advancedInterfaces) {
            sourceInterface.unblockAddress(address);
        }
    }

    private void registerPackets() {
        this.packetPool = new Class[256];
        this.registerPacket((byte)-1, BatchPacket.class);
        this.registerPacket((byte)44, AnimatePacket.class);
        this.registerPacket((byte)56, BlockEntityDataPacket.class);
        this.registerPacket((byte)34, BlockPickRequestPacket.class);
        this.registerPacket((byte)97, BookEditPacket.class);
        this.registerPacket((byte)77, CommandRequestPacket.class);
        this.registerPacket((byte)47, ContainerClosePacket.class);
        this.registerPacket((byte)27, EntityEventPacket.class);
        this.registerPacket((byte)33, InteractPacket.class);
        this.registerPacket((byte)30, InventoryTransactionPacket.class);
        this.registerPacket((byte)1, LoginPacket.class);
        this.registerPacket((byte)68, MapInfoRequestPacket.class);
        this.registerPacket((byte)31, MobEquipmentPacket.class);
        this.registerPacket((byte)101, ModalFormResponsePacket.class);
        this.registerPacket((byte)36, PlayerActionPacket.class);
        this.registerPacket((byte)57, PlayerInputPacket.class);
        this.registerPacket((byte)48, PlayerHotbarPacket.class);
        this.registerPacket((byte)69, RequestChunkRadiusPacket.class);
        this.registerPacket((byte)8, ResourcePackClientResponsePacket.class);
        this.registerPacket((byte)84, ResourcePackChunkRequestPacket.class);
        this.registerPacket((byte)93, PlayerSkinPacket.class);
        this.registerPacket((byte)45, RespawnPacket.class);
        this.registerPacket((byte)60, SetDifficultyPacket.class);
        this.registerPacket((byte)62, SetPlayerGameTypePacket.class);
        this.registerPacket((byte)102, ServerSettingsRequestPacket.class);
        this.registerPacket((byte)9, TextPacket.class);
        this.registerPacket((byte)113, SetLocalPlayerAsInitializedPacket.class);
        this.registerPacket((byte)125, LecternUpdatePacket.class);
        this.registerPacket((byte)-113, NetworkSettingsPacket.class);
        this.registerPacket((byte)-112, PlayerAuthInputPacket.class);
        this.registerPacket((byte)-100, PacketViolationWarningPacket.class);
        this.registerPacket((byte)-118, EmotePacket.class);
        this.registerPacket((byte)-63, RequestNetworkSettingsPacket.class);
        this.registerPacket((byte)4, ClientToServerHandshakePacket.class);
        this.registerPacket((byte)-71, RequestPermissionsPacket.class);
        this.registerPacket((byte)105, SetDefaultGameTypePacket.class);
        this.registerPacket((byte)-116, SettingsCommandPacket.class);
        this.registerPacket((byte)41, SetEntityLinkPacket.class);
        this.registerPacket((byte)40, SetEntityMotionPacket.class);
        this.registerPacket((byte)123, LevelSoundEventPacket.class);
        this.registerPacket((byte)20, RiderJumpPacket.class);
        this.registerPacket((byte)-72, RequestAbilityPacket.class);
        this.registerPacket((byte)115, NetworkStackLatencyPacket.class);
        this.registerPacket((byte)98, NPCRequestPacket.class);
        this.registerPacket((byte)18, MoveEntityAbsolutePacket.class);
        this.registerPacket((byte)32, MobArmorEquipmentPacket.class);
        this.registerPacket((byte)-125, MapCreateLockedCopyPacket.class);
        this.registerPacket((byte)54, GUIDataPickItemPacket.class);
        this.registerPacket((byte)-104, EmoteListPacket.class);
        this.registerPacket((byte)5, DisconnectPacket.class);
        this.registerPacket((byte)74, BossEventPacket.class);
        this.registerPacket((byte)-115, AnvilDamagePacket.class);
    }
}

