/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network;

import cn.nukkit.network.protocol.types.PacketCompressionAlgorithm;
import cn.nukkit.utils.BinaryStream;
import cn.nukkit.utils.SnappyCompression;
import cn.nukkit.utils.Zlib;

public interface CompressionProvider {
    public static final CompressionProvider NONE = new CompressionProvider(){

        @Override
        public byte[] compress(BinaryStream packet, int level) throws Exception {
            return packet.getBuffer();
        }

        @Override
        public byte[] decompress(byte[] compressed) throws Exception {
            return compressed;
        }

        @Override
        public byte[] decompress(byte[] compressed, int maxSize) throws Exception {
            return compressed;
        }

        @Override
        public byte getPrefix() {
            return -1;
        }
    };
    public static final CompressionProvider ZLIB_RAW = new CompressionProvider(){

        @Override
        public byte[] compress(BinaryStream packet, int level) throws Exception {
            return Zlib.deflateRaw(packet.getBuffer(), level);
        }

        @Override
        public byte[] decompress(byte[] compressed) throws Exception {
            return Zlib.inflateRaw(compressed, 0x600000);
        }

        @Override
        public byte[] decompress(byte[] compressed, int maxSize) throws Exception {
            return Zlib.inflateRaw(compressed, maxSize);
        }

        @Override
        public byte getPrefix() {
            return 0;
        }
    };
    public static final CompressionProvider SNAPPY = new CompressionProvider(){

        @Override
        public byte[] compress(BinaryStream packet, int level) throws Exception {
            return SnappyCompression.compress(packet.getBuffer());
        }

        @Override
        public byte[] decompress(byte[] compressed) throws Exception {
            return SnappyCompression.decompress(compressed, 0x600000);
        }

        @Override
        public byte[] decompress(byte[] compressed, int maxSize) throws Exception {
            return SnappyCompression.decompress(compressed, maxSize);
        }

        @Override
        public byte getPrefix() {
            return 1;
        }
    };

    public byte[] compress(BinaryStream var1, int var2) throws Exception;

    public byte[] decompress(byte[] var1) throws Exception;

    default public byte[] decompress(byte[] compressed, int maxSize) throws Exception {
        return this.decompress(compressed);
    }

    public static CompressionProvider from(PacketCompressionAlgorithm algorithm) {
        if (algorithm == null) {
            return NONE;
        }
        if (algorithm == PacketCompressionAlgorithm.ZLIB) {
            return ZLIB_RAW;
        }
        if (algorithm == PacketCompressionAlgorithm.SNAPPY) {
            return SNAPPY;
        }
        throw new UnsupportedOperationException();
    }

    default public byte getPrefix() {
        throw new UnsupportedOperationException();
    }

    public static CompressionProvider byPrefix(byte prefix) {
        switch (prefix) {
            case 0: {
                return ZLIB_RAW;
            }
            case 1: {
                return SNAPPY;
            }
            case -1: {
                return NONE;
            }
        }
        throw new IllegalArgumentException("Unknown compression type: " + prefix);
    }
}

