/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.nbt.tag;

import cn.nukkit.nbt.stream.NBTInputStream;
import cn.nukkit.nbt.stream.NBTOutputStream;
import cn.nukkit.nbt.tag.NumberTag;
import cn.nukkit.nbt.tag.Tag;
import java.io.IOException;

public class DoubleTag
extends NumberTag<Double> {
    public double data;

    @Override
    public Double getData() {
        return this.data;
    }

    @Override
    public void setData(Double data) {
        this.data = data == null ? 0.0 : data;
    }

    public DoubleTag(String name) {
        super(name);
    }

    public DoubleTag(String name, double data) {
        super(name);
        this.data = data;
    }

    @Override
    void write(NBTOutputStream dos) throws IOException {
        dos.writeDouble(this.data);
    }

    @Override
    public void load(NBTInputStream dis) throws IOException {
        this.data = dis.readDouble();
    }

    @Override
    public Double parseValue() {
        return this.data;
    }

    @Override
    public byte getId() {
        return 6;
    }

    @Override
    public String toString() {
        return "DoubleTag " + this.getName() + " (data: " + this.data + ')';
    }

    @Override
    public Tag copy() {
        return new DoubleTag(this.getName(), this.data);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            DoubleTag o = (DoubleTag)obj;
            return this.data == o.data;
        }
        return false;
    }
}

