/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.nbt.tag;

import cn.nukkit.nbt.stream.NBTInputStream;
import cn.nukkit.nbt.stream.NBTOutputStream;
import cn.nukkit.nbt.tag.ByteArrayTag;
import cn.nukkit.nbt.tag.ByteTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.nbt.tag.IntArrayTag;
import cn.nukkit.nbt.tag.IntTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.LongTag;
import cn.nukkit.nbt.tag.NumberTag;
import cn.nukkit.nbt.tag.ShortTag;
import cn.nukkit.nbt.tag.StringTag;
import cn.nukkit.nbt.tag.Tag;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;

public class CompoundTag
extends Tag
implements Cloneable {
    private final Map<String, Tag> tags = new HashMap<String, Tag>();

    public CompoundTag() {
        super("");
    }

    public CompoundTag(String name) {
        super(name);
    }

    @Override
    void write(NBTOutputStream dos) throws IOException {
        for (Map.Entry<String, Tag> entry : this.tags.entrySet()) {
            Tag.writeNamedTag(entry.getValue(), entry.getKey(), dos);
        }
        dos.writeByte(0);
    }

    @Override
    public void load(NBTInputStream dis) throws IOException {
        Tag tag;
        this.tags.clear();
        while ((tag = Tag.readNamedTag(dis)).getId() != 0) {
            this.tags.put(tag.getName(), tag);
        }
    }

    public Collection<Tag> getAllTags() {
        return this.tags.values();
    }

    @Override
    public byte getId() {
        return 10;
    }

    public CompoundTag put(String name, Tag tag) {
        this.tags.put(name, tag.setName(name));
        return this;
    }

    public CompoundTag putByte(String name, int value) {
        this.tags.put(name, new ByteTag(name, value));
        return this;
    }

    public CompoundTag putShort(String name, int value) {
        this.tags.put(name, new ShortTag(name, value));
        return this;
    }

    public CompoundTag putInt(String name, int value) {
        this.tags.put(name, new IntTag(name, value));
        return this;
    }

    public CompoundTag putLong(String name, long value) {
        this.tags.put(name, new LongTag(name, value));
        return this;
    }

    public CompoundTag putFloat(String name, float value) {
        this.tags.put(name, new FloatTag(name, value));
        return this;
    }

    public CompoundTag putDouble(String name, double value) {
        this.tags.put(name, new DoubleTag(name, value));
        return this;
    }

    public CompoundTag putString(String name, String value) {
        this.tags.put(name, new StringTag(name, value));
        return this;
    }

    public CompoundTag putByteArray(String name, byte[] value) {
        this.tags.put(name, new ByteArrayTag(name, value));
        return this;
    }

    public CompoundTag putIntArray(String name, int[] value) {
        this.tags.put(name, new IntArrayTag(name, value));
        return this;
    }

    public CompoundTag putList(ListTag<? extends Tag> listTag) {
        this.tags.put(listTag.getName(), listTag);
        return this;
    }

    public CompoundTag putCompound(String name, CompoundTag value) {
        this.tags.put(name, value.setName(name));
        return this;
    }

    public CompoundTag putBoolean(String string, boolean val) {
        this.putByte(string, val ? 1 : 0);
        return this;
    }

    public Tag get(String name) {
        return this.tags.get(name);
    }

    public boolean contains(String name) {
        return this.tags.containsKey(name);
    }

    public CompoundTag remove(String name) {
        this.tags.remove(name);
        return this;
    }

    public <T extends Tag> T removeAndGet(String name) {
        return (T)this.tags.remove(name);
    }

    public int getByte(String name) {
        Tag t2 = this.tags.get(name);
        if (t2 == null) {
            return 0;
        }
        return ((Number)((NumberTag)t2).getData()).intValue();
    }

    public int getShort(String name) {
        Tag t2 = this.tags.get(name);
        if (t2 == null) {
            return 0;
        }
        return ((Number)((NumberTag)t2).getData()).intValue();
    }

    public int getInt(String name) {
        Tag t2 = this.tags.get(name);
        if (t2 == null) {
            return 0;
        }
        return ((Number)((NumberTag)t2).getData()).intValue();
    }

    public long getLong(String name) {
        Tag t2 = this.tags.get(name);
        if (t2 == null) {
            return 0L;
        }
        return ((Number)((NumberTag)t2).getData()).longValue();
    }

    public float getFloat(String name) {
        Tag t2 = this.tags.get(name);
        if (t2 == null) {
            return 0.0f;
        }
        return ((Number)((NumberTag)t2).getData()).floatValue();
    }

    public double getDouble(String name) {
        Tag t2 = this.tags.get(name);
        if (t2 == null) {
            return 0.0;
        }
        return ((Number)((NumberTag)t2).getData()).doubleValue();
    }

    public String getString(String name) {
        Tag t2 = this.tags.get(name);
        if (t2 == null) {
            return "";
        }
        if (t2 instanceof NumberTag) {
            return String.valueOf(((NumberTag)t2).getData());
        }
        return ((StringTag)t2).data;
    }

    public byte[] getByteArray(String name) {
        Tag t2 = this.tags.get(name);
        if (t2 == null) {
            return new byte[0];
        }
        return ((ByteArrayTag)t2).data;
    }

    public byte[] getByteArray(String name, int defaultSize) {
        Tag t2 = this.tags.get(name);
        if (t2 == null) {
            return new byte[defaultSize];
        }
        return ((ByteArrayTag)t2).data;
    }

    public int[] getIntArray(String name) {
        Tag t2 = this.tags.get(name);
        if (t2 == null) {
            return new int[0];
        }
        return ((IntArrayTag)t2).data;
    }

    public CompoundTag getCompound(String name) {
        Tag t2 = this.tags.get(name);
        if (t2 == null) {
            return new CompoundTag(name);
        }
        return (CompoundTag)t2;
    }

    public ListTag<? extends Tag> getList(String name) {
        Tag t2 = this.tags.get(name);
        if (t2 == null) {
            return new ListTag(name);
        }
        return (ListTag)t2;
    }

    public <T extends Tag> ListTag<T> getList(String name, Class<T> type) {
        Tag t2 = this.tags.get(name);
        if (t2 != null) {
            return (ListTag)t2;
        }
        return new ListTag(name);
    }

    public Map<String, Tag> getTags() {
        return new HashMap<String, Tag>(this.tags);
    }

    @Override
    public Map<String, Object> parseValue() {
        HashMap<String, Object> value = new HashMap<String, Object>(this.tags.size());
        for (Map.Entry<String, Tag> entry : this.tags.entrySet()) {
            value.put(entry.getKey(), entry.getValue().parseValue());
        }
        return value;
    }

    public boolean getBoolean(String name) {
        return this.getByte(name) != 0;
    }

    public boolean getBoolean(String name, boolean def) {
        Tag t2 = this.tags.get(name);
        if (t2 == null) {
            return def;
        }
        return ((Number)((NumberTag)t2).getData()).intValue() != 0;
    }

    @Override
    public String toString() {
        StringJoiner joiner = new StringJoiner(",\n\t");
        this.tags.forEach((key, tag) -> joiner.add('\'' + key + "' : " + tag.toString().replace("\n", "\n\t")));
        return "CompoundTag '" + this.getName() + "' (" + this.tags.size() + " entries) {\n\t" + joiner.toString() + "\n}";
    }

    @Override
    public void print(String prefix, PrintStream out) {
        super.print(prefix, out);
        out.println(prefix + '{');
        String orgPrefix = prefix;
        prefix = prefix + "   ";
        for (Tag tag : this.tags.values()) {
            tag.print(prefix, out);
        }
        out.println(orgPrefix + '}');
    }

    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    @Override
    public CompoundTag copy() {
        CompoundTag tag = new CompoundTag(this.getName());
        for (Map.Entry<String, Tag> entry : this.tags.entrySet()) {
            tag.put(entry.getKey(), entry.getValue().copy());
        }
        return tag;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            CompoundTag o = (CompoundTag)obj;
            return this.tags.entrySet().equals(o.tags.entrySet());
        }
        return false;
    }

    public boolean exist(String name) {
        return this.tags.containsKey(name);
    }

    public CompoundTag clone() {
        CompoundTag nbt = new CompoundTag();
        this.getTags().forEach((key, value) -> nbt.put((String)key, value.copy()));
        return nbt;
    }
}

