/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.nbt.stream;

import cn.nukkit.nbt.stream.PGZIPBlock;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PGZIPOutputStream
extends FilterOutputStream {
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private static final int GZIP_MAGIC = 35615;
    private final IntList blockSizes = new IntArrayList();
    private int level = 1;
    private int strategy = 0;
    private final ExecutorService executor;
    private final int nthreads;
    private final CRC32 crc = new CRC32();
    private final BlockingQueue<Future<byte[]>> emitQueue;
    private PGZIPBlock block = new PGZIPBlock(this);
    private int bytesWritten = 0;

    public static ExecutorService getSharedThreadPool() {
        return EXECUTOR;
    }

    protected Deflater newDeflater() {
        Deflater def = new Deflater(this.level, true);
        def.setStrategy(this.strategy);
        return def;
    }

    public void setStrategy(int strategy) {
        this.strategy = strategy;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    protected static DeflaterOutputStream newDeflaterOutputStream(OutputStream out, Deflater deflater) {
        return new DeflaterOutputStream(out, deflater, 512, true);
    }

    public PGZIPOutputStream(OutputStream out, ExecutorService executor, int nthreads) throws IOException {
        super(out);
        this.executor = executor;
        this.nthreads = nthreads;
        this.emitQueue = new ArrayBlockingQueue<Future<byte[]>>(nthreads);
        this.writeHeader();
    }

    public PGZIPOutputStream(OutputStream out, int nthreads) throws IOException {
        this(out, PGZIPOutputStream.getSharedThreadPool(), nthreads);
    }

    public PGZIPOutputStream(OutputStream out) throws IOException {
        this(out, Runtime.getRuntime().availableProcessors());
    }

    private void writeHeader() throws IOException {
        this.out.write(new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 3});
    }

    @Override
    public void write(int b) throws IOException {
        byte[] single = new byte[]{(byte)(b & 0xFF)};
        this.write(single);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.crc.update(b, off, len);
        this.bytesWritten += len;
        while (len > 0) {
            int capacity = this.block.in.length - this.block.in_length;
            if (len >= capacity) {
                System.arraycopy(b, off, this.block.in, this.block.in_length, capacity);
                this.block.in_length += capacity;
                off += capacity;
                len -= capacity;
                this.submit();
                continue;
            }
            System.arraycopy(b, off, this.block.in, this.block.in_length, len);
            this.block.in_length += len;
            break;
        }
    }

    private void submit() throws IOException {
        this.emitUntil(this.nthreads - 1);
        this.emitQueue.add(this.executor.submit(this.block));
        this.block = new PGZIPBlock(this);
    }

    private void tryEmit() throws IOException, InterruptedException, ExecutionException {
        Future future;
        while ((future = (Future)this.emitQueue.peek()) != null) {
            if (!future.isDone()) {
                return;
            }
            this.emitQueue.remove();
            byte[] toWrite = (byte[])future.get();
            this.blockSizes.add(toWrite.length);
            this.out.write(toWrite);
        }
        return;
    }

    private void emitUntil(int taskCountAllowed) throws IOException {
        try {
            while (this.emitQueue.size() > taskCountAllowed) {
                Future future = (Future)this.emitQueue.remove();
                byte[] toWrite = (byte[])future.get();
                this.blockSizes.add(toWrite.length);
                this.out.write(toWrite);
            }
            this.tryEmit();
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.block.in_length > 0) {
            this.submit();
        }
        this.emitUntil(0);
        super.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.bytesWritten >= 0) {
            this.flush();
            PGZIPOutputStream.newDeflaterOutputStream(this.out, this.newDeflater()).finish();
            ByteBuffer buf = ByteBuffer.allocate(8);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            buf.putInt((int)this.crc.getValue());
            buf.putInt(this.bytesWritten);
            this.out.write(buf.array());
            this.out.flush();
            this.out.close();
            this.bytesWritten = Integer.MIN_VALUE;
        }
    }
}

