/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.nbt.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class FastByteArrayOutputStream
extends OutputStream {
    public static final long ONEOVERPHI = 106039L;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public byte[] array;
    public int length;
    private int position;

    public FastByteArrayOutputStream() {
        this(16);
    }

    public FastByteArrayOutputStream(int initialCapacity) {
        this.array = new byte[initialCapacity];
    }

    public FastByteArrayOutputStream(byte[] a) {
        this.array = a;
    }

    public FastByteArrayOutputStream reset() {
        this.length = 0;
        this.position = 0;
        return this;
    }

    @Override
    public void write(int b) {
        if (this.position >= this.array.length) {
            this.array = FastByteArrayOutputStream.grow(this.array, this.position + 1, this.length);
        }
        this.array[this.position++] = (byte)b;
        if (this.length < this.position) {
            this.length = this.position;
        }
    }

    public static void ensureOffsetLength(int arrayLength, int offset, int length) {
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length (" + length + ") is negative");
        }
        if (offset + length > arrayLength) {
            throw new ArrayIndexOutOfBoundsException("Last index (" + (offset + length) + ") is greater than array length (" + arrayLength + ')');
        }
    }

    public static byte[] grow(byte[] array, int length) {
        if (length > array.length) {
            byte[] t2 = new byte[(int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE)];
            System.arraycopy(array, 0, t2, 0, array.length);
            return t2;
        }
        return array;
    }

    public static byte[] grow(byte[] array, int length, int preserve) {
        if (length > array.length) {
            byte[] t2 = new byte[(int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE)];
            System.arraycopy(array, 0, t2, 0, preserve);
            return t2;
        }
        return array;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.position + len > this.array.length) {
            this.array = FastByteArrayOutputStream.grow(this.array, this.position + len, this.position);
        }
        System.arraycopy(b, off, this.array, this.position, len);
        if (this.position + len > this.length) {
            this.length = this.position += len;
        }
    }

    public void position(long newPosition) {
        if (newPosition > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Position too large: " + newPosition);
        }
        this.position = (int)newPosition;
    }

    public long position() {
        return this.position;
    }

    public long length() throws IOException {
        return this.length;
    }

    public byte[] toByteArray() {
        return Arrays.copyOfRange(this.array, 0, this.position);
    }
}

