/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.metrics;

import cn.nukkit.Server;
import cn.nukkit.metrics.Metrics;
import cn.nukkit.utils.Config;
import cn.nukkit.utils.Utils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NukkitMetrics {
    private static boolean metricsStarted = false;
    private final Server server;
    private boolean enabled;
    private String serverUUID;
    private boolean logFailedRequests;

    public NukkitMetrics(Server server) {
        this.server = server;
        if (metricsStarted) {
            return;
        }
        try {
            this.loadConfig();
        }
        catch (IOException ex) {
            server.getLogger().logException(ex);
        }
        if (this.enabled) {
            Metrics metrics = new Metrics("Nukkit", this.serverUUID, this.logFailedRequests, server.getLogger());
            metrics.addCustomChart(new Metrics.SingleLineChart("players", server::getOnlinePlayersCount));
            metrics.addCustomChart(new Metrics.SimplePie("codename", server::getCodename));
            metrics.addCustomChart(new Metrics.SimplePie("minecraft_version", server::getVersion));
            metrics.addCustomChart(new Metrics.SimplePie("nukkit_version", server::getNukkitVersion));
            metrics.addCustomChart(new Metrics.SimplePie("xbox_auth", () -> server.xboxAuth ? "Required" : "Not required"));
            metrics.addCustomChart(new Metrics.AdvancedPie("player_platform", () -> {
                HashMap valueMap = new HashMap();
                server.getOnlinePlayers().forEach((uuid, player) -> {
                    String deviceOS = Utils.getOS(player);
                    if (!valueMap.containsKey(deviceOS)) {
                        valueMap.put(deviceOS, 1);
                    } else {
                        valueMap.put(deviceOS, (Integer)valueMap.get(deviceOS) + 1);
                    }
                });
                return valueMap;
            }));
            metrics.addCustomChart(new Metrics.AdvancedPie("player_game_version", () -> {
                HashMap valueMap = new HashMap();
                server.getOnlinePlayers().forEach((uuid, player) -> {
                    String gameVersion = player.getLoginChainData().getGameVersion();
                    if (!valueMap.containsKey(gameVersion)) {
                        valueMap.put(gameVersion, 1);
                    } else {
                        valueMap.put(gameVersion, (Integer)valueMap.get(gameVersion) + 1);
                    }
                });
                return valueMap;
            }));
            metrics.addCustomChart(new Metrics.DrilldownPie("java_version", () -> {
                String release;
                HashMap map = new HashMap();
                String javaVersion = System.getProperty("java.version");
                HashMap<String, Integer> entry = new HashMap<String, Integer>();
                entry.put(javaVersion, 1);
                String majorVersion = javaVersion.split("\\.")[0];
                int indexOf = javaVersion.lastIndexOf(46);
                if (majorVersion.equals("1")) {
                    release = "Java " + javaVersion.substring(0, indexOf);
                } else {
                    Matcher versionMatcher = Pattern.compile("\\d+").matcher(majorVersion);
                    if (versionMatcher.find()) {
                        majorVersion = versionMatcher.group(0);
                    }
                    release = "Java " + majorVersion;
                }
                map.put(release, entry);
                return map;
            }));
            metricsStarted = true;
        }
    }

    private void loadConfig() throws IOException {
        File bStatsFolder = new File(this.server.getPluginPath(), "bStats");
        if (!bStatsFolder.exists() && !bStatsFolder.mkdirs()) {
            this.server.getLogger().warning("Failed to create bStats metrics directory");
            return;
        }
        File configFile = new File(bStatsFolder, "config.yml");
        if (!configFile.exists()) {
            this.writeFile(configFile, "# bStats collects some data for plugin authors like how many servers are using their plugins.", "# To honor their work, you should not disable it.", "# This has nearly no effect on the server performance!", "# Check out https://bStats.org/ to learn more :)", "enabled: true", "serverUuid: \"" + UUID.randomUUID().toString() + "\"", "logFailedRequests: false");
        }
        Config config = new Config(configFile, 2);
        this.enabled = config.getBoolean("enabled", true);
        this.serverUUID = config.getString("serverUuid");
        this.logFailedRequests = config.getBoolean("logFailedRequests", false);
    }

    private void writeFile(File file, String ... lines) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            for (String line : lines) {
                writer.write(line);
                writer.newLine();
            }
        }
    }
}

