/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.math;

import cn.nukkit.math.Angle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.math.Vector2;
import cn.nukkit.math.Vector3f;

public class Vector3
implements Cloneable {
    public double x;
    public double y;
    public double z;

    public Vector3() {
        this(0.0, 0.0, 0.0);
    }

    public Vector3(double x) {
        this(x, 0.0, 0.0);
    }

    public Vector3(double x, double y) {
        this(x, y, 0.0);
    }

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public Vector3 setX(double x) {
        this.x = x;
        return this;
    }

    public Vector3 setY(double y) {
        this.y = y;
        return this;
    }

    public Vector3 setZ(double z) {
        this.z = z;
        return this;
    }

    public int getFloorX() {
        return (int)Math.floor(this.x);
    }

    public int getFloorY() {
        return (int)Math.floor(this.y);
    }

    public int getFloorZ() {
        return (int)Math.floor(this.z);
    }

    public int getChunkX() {
        return this.getFloorX() >> 4;
    }

    public int getChunkZ() {
        return this.getFloorZ() >> 4;
    }

    public double getRight() {
        return this.x;
    }

    public double getUp() {
        return this.y;
    }

    public double getForward() {
        return this.z;
    }

    public double getSouth() {
        return this.x;
    }

    public double getWest() {
        return this.z;
    }

    public Vector3 add(double x) {
        return this.add(x, 0.0, 0.0);
    }

    public Vector3 add(double x, double y) {
        return this.add(x, y, 0.0);
    }

    public Vector3 add(double x, double y, double z) {
        return new Vector3(this.x + x, this.y + y, this.z + z);
    }

    public Vector3 add(Vector3 x) {
        return new Vector3(this.x + x.x, this.y + x.y, this.z + x.z);
    }

    public Vector3 subtract() {
        return this.subtract(0.0, 0.0, 0.0);
    }

    public Vector3 subtract(double x) {
        return this.subtract(x, 0.0, 0.0);
    }

    public Vector3 subtract(double x, double y) {
        return this.subtract(x, y, 0.0);
    }

    public Vector3 subtract(double x, double y, double z) {
        return this.add(-x, -y, -z);
    }

    public Vector3 subtract(Vector3 x) {
        return this.add(-x.x, -x.y, -x.z);
    }

    public Vector3 multiply(double number) {
        return new Vector3(this.x * number, this.y * number, this.z * number);
    }

    public Vector3 divide(double number) {
        return new Vector3(this.x / number, this.y / number, this.z / number);
    }

    public Vector3 ceil() {
        return new Vector3((int)Math.ceil(this.x), (int)Math.ceil(this.y), (int)Math.ceil(this.z));
    }

    public Vector3 floor() {
        return new Vector3(this.getFloorX(), this.getFloorY(), this.getFloorZ());
    }

    public Vector3 round() {
        return new Vector3(Math.round(this.x), Math.round(this.y), Math.round(this.z));
    }

    public Vector3 abs() {
        return new Vector3((int)Math.abs(this.x), (int)Math.abs(this.y), (int)Math.abs(this.z));
    }

    public Vector3 getSide(BlockFace face) {
        return this.getSide(face, 1);
    }

    public Vector3 getSide(BlockFace face, int step) {
        return new Vector3(this.x + (double)(face.getXOffset() * step), this.y + (double)(face.getYOffset() * step), this.z + (double)(face.getZOffset() * step));
    }

    public Vector3 getSideVec(BlockFace face) {
        return new Vector3(this.getX() + (double)face.getXOffset(), this.getY() + (double)face.getYOffset(), this.getZ() + (double)face.getZOffset());
    }

    public Vector3 getSideVec(BlockFace face, int step) {
        return new Vector3(this.x + (double)(face.getXOffset() * step), this.y + (double)(face.getYOffset() * step), this.z + (double)(face.getZOffset() * step));
    }

    public Vector3 up() {
        return this.up(1);
    }

    public Vector3 up(int step) {
        return this.getSide(BlockFace.UP, step);
    }

    public Vector3 down() {
        return this.down(1);
    }

    public Vector3 down(int step) {
        return this.getSide(BlockFace.DOWN, step);
    }

    public Vector3 north() {
        return this.north(1);
    }

    public Vector3 north(int step) {
        return this.getSide(BlockFace.NORTH, step);
    }

    public Vector3 south() {
        return this.south(1);
    }

    public Vector3 south(int step) {
        return this.getSide(BlockFace.SOUTH, step);
    }

    public Vector3 east() {
        return this.east(1);
    }

    public Vector3 east(int step) {
        return this.getSide(BlockFace.EAST, step);
    }

    public Vector3 west() {
        return this.west(1);
    }

    public Vector3 west(int step) {
        return this.getSide(BlockFace.WEST, step);
    }

    public double distance(Vector3 pos) {
        return Math.sqrt(this.distanceSquared(pos));
    }

    public double distanceSquared(Vector3 pos) {
        return Math.pow(this.x - pos.x, 2.0) + Math.pow(this.y - pos.y, 2.0) + Math.pow(this.z - pos.z, 2.0);
    }

    public double maxPlainDistance() {
        return this.maxPlainDistance(0.0, 0.0);
    }

    public double maxPlainDistance(double x) {
        return this.maxPlainDistance(x, 0.0);
    }

    public double maxPlainDistance(double x, double z) {
        return Math.max(Math.abs(this.x - x), Math.abs(this.z - z));
    }

    public double maxPlainDistance(Vector2 vector) {
        return this.maxPlainDistance(vector.x, vector.y);
    }

    public double maxPlainDistance(Vector3 x) {
        return this.maxPlainDistance(x.x, x.z);
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3 normalize() {
        double len = this.lengthSquared();
        if (len > 0.0) {
            return this.divide(Math.sqrt(len));
        }
        return new Vector3(0.0, 0.0, 0.0);
    }

    public double dot(Vector3 v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public Vector3 cross(Vector3 v) {
        return new Vector3(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
    }

    public Angle angleBetween(Vector3 v) {
        return Angle.fromRadian(Math.acos(Math.min(Math.max(this.normalize().dot(v.normalize()), -1.0), 1.0)));
    }

    public Vector3 getIntermediateWithXValue(Vector3 v, double x) {
        double xDiff = v.x - this.x;
        double yDiff = v.y - this.y;
        double zDiff = v.z - this.z;
        if (xDiff * xDiff < 1.0E-7) {
            return null;
        }
        double f = (x - this.x) / xDiff;
        if (f < 0.0 || f > 1.0) {
            return null;
        }
        return new Vector3(this.x + xDiff * f, this.y + yDiff * f, this.z + zDiff * f);
    }

    public Vector3 getIntermediateWithYValue(Vector3 v, double y) {
        double xDiff = v.x - this.x;
        double yDiff = v.y - this.y;
        double zDiff = v.z - this.z;
        if (yDiff * yDiff < 1.0E-7) {
            return null;
        }
        double f = (y - this.y) / yDiff;
        if (f < 0.0 || f > 1.0) {
            return null;
        }
        return new Vector3(this.x + xDiff * f, this.y + yDiff * f, this.z + zDiff * f);
    }

    public Vector3 getIntermediateWithZValue(Vector3 v, double z) {
        double xDiff = v.x - this.x;
        double yDiff = v.y - this.y;
        double zDiff = v.z - this.z;
        if (zDiff * zDiff < 1.0E-7) {
            return null;
        }
        double f = (z - this.z) / zDiff;
        if (f < 0.0 || f > 1.0) {
            return null;
        }
        return new Vector3(this.x + xDiff * f, this.y + yDiff * f, this.z + zDiff * f);
    }

    public Vector3 setComponents(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public String toString() {
        return "Vector3(x=" + this.x + ",y=" + this.y + ",z=" + this.z + ')';
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Vector3)) {
            return false;
        }
        Vector3 other = (Vector3)obj;
        return this.x == other.x && this.y == other.y && this.z == other.z;
    }

    public int hashCode() {
        return (int)this.x ^ (int)this.z << 12 ^ (int)this.y << 24;
    }

    public int rawHashCode() {
        return super.hashCode();
    }

    public Vector3 clone() {
        try {
            return (Vector3)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Vector3f asVector3f() {
        return new Vector3f((float)this.x, (float)this.y, (float)this.z);
    }

    public BlockVector3 asBlockVector3() {
        return new BlockVector3(this.getFloorX(), this.getFloorY(), this.getFloorZ());
    }
}

