/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.math;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.CRC32;

public class NukkitRandom {
    protected long seed;

    public NukkitRandom() {
        this(-1L);
    }

    public NukkitRandom(long seeds) {
        if (seeds == -1L) {
            seeds = System.currentTimeMillis() / 1000L;
        }
        this.setSeed(seeds);
    }

    public void setSeed(long seeds) {
        CRC32 crc32 = new CRC32();
        ByteBuffer buffer = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
        buffer.putInt((int)seeds);
        crc32.update(buffer.array());
        this.seed = crc32.getValue();
    }

    public int nextSignedInt() {
        int t2 = ((int)(this.seed * 65535L + 31337L) >> 8) + 1337;
        this.seed ^= (long)t2;
        return t2;
    }

    public int nextInt() {
        return this.nextSignedInt() & Integer.MAX_VALUE;
    }

    public double nextDouble() {
        return (double)this.nextInt() / 2.147483647E9;
    }

    public float nextFloat() {
        return (float)this.nextInt() / 2.1474836E9f;
    }

    public float nextSignedFloat() {
        return (float)this.nextInt() / 2.1474836E9f;
    }

    public double nextSignedDouble() {
        return (double)this.nextSignedInt() / 2.147483647E9;
    }

    public boolean nextBoolean() {
        return (this.nextSignedInt() & 1) == 0;
    }

    public int nextRange() {
        return this.nextRange(0, Integer.MAX_VALUE);
    }

    public int nextRange(int start) {
        return this.nextRange(start, Integer.MAX_VALUE);
    }

    public int nextRange(int start, int end) {
        return start + this.nextInt() % (end + 1 - start);
    }

    public int nextBoundedInt(int bound) {
        return bound == 0 ? 0 : this.nextInt() % bound;
    }
}

