/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.math;

import cn.nukkit.math.NukkitRandom;

public class NukkitMath {
    public static int floorDouble(double n) {
        int i = (int)n;
        return n >= (double)i ? i : i - 1;
    }

    public static int ceilDouble(double n) {
        int i = (int)(n + 1.0);
        return n >= (double)i ? i : i - 1;
    }

    public static int floorFloat(float n) {
        int i = (int)n;
        return n >= (float)i ? i : i - 1;
    }

    public static int ceilFloat(float n) {
        int i = (int)(n + 1.0f);
        return n >= (float)i ? i : i - 1;
    }

    public static int randomRange(NukkitRandom random) {
        return NukkitMath.randomRange(random, 0);
    }

    public static int randomRange(NukkitRandom random, int start) {
        return NukkitMath.randomRange(random, 0, Integer.MAX_VALUE);
    }

    public static int randomRange(NukkitRandom random, int start, int end) {
        return start + random.nextInt() % (end + 1 - start);
    }

    public static double round(double d) {
        return NukkitMath.round(d, 0);
    }

    public static double round(double d, int precision) {
        return (double)Math.round(d * Math.pow(10.0, precision)) / Math.pow(10.0, precision);
    }

    public static double clamp(double value, double min2, double max) {
        return value < min2 ? min2 : (value > max ? max : value);
    }

    public static int clamp(int value, int min2, int max) {
        return value < min2 ? min2 : (value > max ? max : value);
    }

    public static float clamp(float value, float min2, float max) {
        return value < min2 ? min2 : (value > max ? max : value);
    }

    public static double getDirection(double diffX, double diffZ) {
        diffX = Math.abs(diffX);
        diffZ = Math.abs(diffZ);
        return Math.max(diffX, diffZ);
    }

    public static double lerp(double a, double b, double t2) {
        return a + (b - a) * t2;
    }
}

