/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.math;

import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.math.Vector3f;

public class BlockVector3
implements Cloneable {
    public int x;
    public int y;
    public int z;

    public BlockVector3(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockVector3() {
    }

    public BlockVector3 setComponents(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public BlockVector3 setX(int x) {
        this.x = x;
        return this;
    }

    public BlockVector3 setY(int y) {
        this.y = y;
        return this;
    }

    public BlockVector3 setZ(int z) {
        this.z = z;
        return this;
    }

    public Vector3 add(double x) {
        return this.add(x, 0.0, 0.0);
    }

    public Vector3 add(double x, double y) {
        return this.add(x, y, 0.0);
    }

    public Vector3 add(double x, double y, double z) {
        return new Vector3((double)this.x + x, (double)this.y + y, (double)this.z + z);
    }

    public Vector3 add(Vector3 x) {
        return new Vector3((double)this.x + x.getX(), (double)this.y + x.getY(), (double)this.z + x.getZ());
    }

    public Vector3 subtract(double x) {
        return this.subtract(x, 0.0, 0.0);
    }

    public Vector3 subtract(double x, double y) {
        return this.subtract(x, y, 0.0);
    }

    public Vector3 subtract(double x, double y, double z) {
        return this.add(-x, -y, -z);
    }

    public Vector3 subtract(Vector3 x) {
        return this.add(-x.getX(), -x.getY(), -x.getZ());
    }

    public BlockVector3 add(int x) {
        return this.add(x, 0, 0);
    }

    public BlockVector3 add(int x, int y) {
        return this.add(x, y, 0);
    }

    public BlockVector3 add(int x, int y, int z) {
        return new BlockVector3(this.x + x, this.y + y, this.z + z);
    }

    public BlockVector3 add(BlockVector3 x) {
        return new BlockVector3(this.x + x.x, this.y + x.y, this.z + x.z);
    }

    public BlockVector3 subtract() {
        return this.subtract(0, 0, 0);
    }

    public BlockVector3 subtract(int x) {
        return this.subtract(x, 0, 0);
    }

    public BlockVector3 subtract(int x, int y) {
        return this.subtract(x, y, 0);
    }

    public BlockVector3 subtract(int x, int y, int z) {
        return this.add(-x, -y, -z);
    }

    public BlockVector3 subtract(BlockVector3 x) {
        return this.add(-x.x, -x.y, -x.z);
    }

    public BlockVector3 multiply(int number) {
        return new BlockVector3(this.x * number, this.y * number, this.z * number);
    }

    public BlockVector3 divide(int number) {
        return new BlockVector3(this.x / number, this.y / number, this.z / number);
    }

    public BlockVector3 getSide(BlockFace face) {
        return this.getSide(face, 1);
    }

    public BlockVector3 getSide(BlockFace face, int step) {
        return new BlockVector3(this.x + face.getXOffset() * step, this.y + face.getYOffset() * step, this.z + face.getZOffset() * step);
    }

    public BlockVector3 up() {
        return this.up(1);
    }

    public BlockVector3 up(int step) {
        return this.getSide(BlockFace.UP, step);
    }

    public BlockVector3 down() {
        return this.down(1);
    }

    public BlockVector3 down(int step) {
        return this.getSide(BlockFace.DOWN, step);
    }

    public BlockVector3 north() {
        return this.north(1);
    }

    public BlockVector3 north(int step) {
        return this.getSide(BlockFace.NORTH, step);
    }

    public BlockVector3 south() {
        return this.south(1);
    }

    public BlockVector3 south(int step) {
        return this.getSide(BlockFace.SOUTH, step);
    }

    public BlockVector3 east() {
        return this.east(1);
    }

    public BlockVector3 east(int step) {
        return this.getSide(BlockFace.EAST, step);
    }

    public BlockVector3 west() {
        return this.west(1);
    }

    public BlockVector3 west(int step) {
        return this.getSide(BlockFace.WEST, step);
    }

    public double distance(Vector3 pos) {
        return Math.sqrt(this.distanceSquared(pos));
    }

    public double distance(BlockVector3 pos) {
        return Math.sqrt(this.distanceSquared(pos));
    }

    public double distanceSquared(Vector3 pos) {
        return this.distanceSquared(pos.x, pos.y, pos.z);
    }

    public double distanceSquared(BlockVector3 pos) {
        return this.distanceSquared(pos.x, pos.y, pos.z);
    }

    public double distanceSquared(double x, double y, double z) {
        return Math.pow((double)this.x - x, 2.0) + Math.pow((double)this.y - y, 2.0) + Math.pow((double)this.z - z, 2.0);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockVector3)) {
            return false;
        }
        BlockVector3 that = (BlockVector3)o;
        return this.x == that.x && this.y == that.y && this.z == that.z;
    }

    public final int hashCode() {
        return this.x ^ this.z << 12 ^ this.y << 24;
    }

    public String toString() {
        return "BlockVector3(level=,x=" + this.x + ",y=" + this.y + ",z=" + this.z + ')';
    }

    public BlockVector3 clone() {
        try {
            return (BlockVector3)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Vector3 asVector3() {
        return new Vector3(this.x, this.y, this.z);
    }

    public Vector3f asVector3f() {
        return new Vector3f(this.x, this.y, this.z);
    }
}

