/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.math;

import java.util.Locale;

public final class Angle
implements Comparable<Angle> {
    private final float floatValue;
    private final double doubleValue;
    private final boolean isDegree;
    private final boolean isOriginDouble;

    public static Angle fromDegree(float floatDegree) {
        return new Angle(floatDegree, true);
    }

    public static Angle fromDegree(double doubleDegree) {
        return new Angle(doubleDegree, true);
    }

    public static Angle fromRadian(float floatRadian) {
        return new Angle(floatRadian, false);
    }

    public static Angle fromRadian(double doubleRadian) {
        return new Angle(doubleRadian, false);
    }

    public static Angle asin(double v) {
        return Angle.fromRadian(Math.asin(v));
    }

    public static Angle acos(double v) {
        return Angle.fromRadian(Math.acos(v));
    }

    public static Angle atan(double v) {
        return Angle.fromRadian(Math.atan(v));
    }

    public double sin() {
        return Math.sin(this.asDoubleRadian());
    }

    public double cos() {
        return Math.cos(this.asDoubleRadian());
    }

    public double tan() {
        return Math.tan(this.asDoubleRadian());
    }

    public float asFloatRadian() {
        if (this.isOriginDouble) {
            if (this.isDegree) {
                return (float)(this.doubleValue * Math.PI / 180.0);
            }
            return (float)this.doubleValue;
        }
        if (this.isDegree) {
            return this.floatValue * (float)Math.PI / 180.0f;
        }
        return this.floatValue;
    }

    public double asDoubleRadian() {
        if (this.isOriginDouble) {
            if (this.isDegree) {
                return this.doubleValue * Math.PI / 180.0;
            }
            return this.doubleValue;
        }
        if (this.isDegree) {
            return (double)this.floatValue * Math.PI / 180.0;
        }
        return this.floatValue;
    }

    public float asFloatDegree() {
        if (this.isOriginDouble) {
            if (this.isDegree) {
                return (float)this.doubleValue;
            }
            return (float)(this.doubleValue * 180.0 / Math.PI);
        }
        if (this.isDegree) {
            return this.floatValue;
        }
        return this.floatValue * 180.0f / (float)Math.PI;
    }

    public double asDoubleDegree() {
        if (this.isOriginDouble) {
            if (this.isDegree) {
                return this.doubleValue;
            }
            return this.doubleValue * 180.0 / Math.PI;
        }
        if (this.isDegree) {
            return this.floatValue;
        }
        return (double)this.floatValue * 180.0 / Math.PI;
    }

    public static int compare(Angle a, Angle b) {
        return a.compareTo(b);
    }

    public String toString() {
        Object[] objectArray = new Object[6];
        objectArray[0] = this.isOriginDouble ? "Double" : "Float";
        objectArray[1] = this.isOriginDouble ? this.doubleValue : (double)this.floatValue;
        Object object = objectArray[2] = this.isDegree ? "deg" : "rad";
        objectArray[3] = this.isDegree ? (this.isOriginDouble ? this.asDoubleRadian() : (double)this.asFloatRadian()) : (this.isOriginDouble ? this.asDoubleDegree() : (double)this.asFloatDegree());
        objectArray[4] = this.isDegree ? "rad" : "deg";
        objectArray[5] = this.hashCode();
        return String.format(Locale.ROOT, "Angle[%s, %f%s = %f%s] [%d]", objectArray);
    }

    @Override
    public int compareTo(Angle o) {
        return Double.compare(this.asDoubleRadian(), o.asDoubleRadian());
    }

    public boolean equals(Object obj) {
        return obj instanceof Angle && this.compareTo((Angle)obj) == 0;
    }

    public int hashCode() {
        int hash = this.isOriginDouble ? Double.hashCode(this.doubleValue) : Float.hashCode(this.floatValue);
        if (this.isDegree) {
            hash ^= 0xABCD1234;
        }
        return hash;
    }

    private Angle(float floatValue, boolean isDegree) {
        this.isOriginDouble = false;
        this.floatValue = floatValue;
        this.doubleValue = 0.0;
        this.isDegree = isDegree;
    }

    private Angle(double doubleValue, boolean isDegree) {
        this.isOriginDouble = true;
        this.floatValue = 0.0f;
        this.doubleValue = doubleValue;
        this.isDegree = isDegree;
    }
}

