/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.persistence.impl;

import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.level.persistence.ImmutableCompoundTag;
import cn.nukkit.level.persistence.PersistentDataContainer;
import cn.nukkit.nbt.tag.CompoundTag;

public class PersistentDataContainerBlockWrapper
implements PersistentDataContainer {
    private final BlockEntity blockEntity;
    private CompoundTag storage;

    public PersistentDataContainerBlockWrapper(BlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    @Override
    public CompoundTag getReadStorage() {
        CompoundTag storage = this.getInternalStorage();
        if (storage == null) {
            return ImmutableCompoundTag.EMPTY;
        }
        return storage;
    }

    @Override
    public CompoundTag getStorage() {
        CompoundTag storage = this.getInternalStorage();
        if (storage == null) {
            storage = new CompoundTag();
            this.setStorage(storage);
        }
        return storage;
    }

    private CompoundTag getInternalStorage() {
        if (this.storage != null) {
            return this.storage;
        }
        if (this.blockEntity.namedTag.contains("persistent_storage")) {
            this.storage = this.blockEntity.namedTag.getCompound("persistent_storage");
            return this.storage;
        }
        return null;
    }

    @Override
    public void setStorage(CompoundTag storage) {
        this.blockEntity.namedTag.putCompound("persistent_storage", storage);
        this.storage = storage;
    }

    @Override
    public void clearStorage() {
        this.blockEntity.namedTag.remove("persistent_storage");
        this.storage = null;
    }
}

