/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.persistence;

import cn.nukkit.nbt.tag.ByteTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.nbt.tag.IntTag;
import cn.nukkit.nbt.tag.StringTag;
import cn.nukkit.nbt.tag.Tag;
import java.util.function.Function;
import lombok.Generated;

public interface PersistentDataType<T> {
    public static final PersistentDataType<Boolean> BOOLEAN = new PrimitiveDataType<Boolean, ByteTag>(Boolean.class, ByteTag.class, val -> new ByteTag(null, val != false ? 1 : 0), tag -> tag.parseValue() == 1);
    public static final PersistentDataType<Byte> BYTE = new PrimitiveDataType<Byte, ByteTag>(Byte.class, ByteTag.class, val -> new ByteTag(null, val.byteValue()), tag -> tag.parseValue().byteValue());
    public static final PersistentDataType<Integer> INT = new PrimitiveDataType<Integer, IntTag>(Integer.class, IntTag.class, val -> new IntTag(null, (int)val), IntTag::parseValue);
    public static final PersistentDataType<Double> DOUBLE = new PrimitiveDataType<Double, DoubleTag>(Double.class, DoubleTag.class, val -> new DoubleTag(null, (double)val), DoubleTag::parseValue);
    public static final PersistentDataType<Float> FLOAT = new PrimitiveDataType<Float, FloatTag>(Float.class, FloatTag.class, val -> new FloatTag(null, val.floatValue()), FloatTag::parseValue);
    public static final PersistentDataType<String> STRING = new PrimitiveDataType<String, StringTag>(String.class, StringTag.class, val -> new StringTag(null, (String)val), StringTag::parseValue);

    public Class<T> getImplementation();

    public Tag serialize(T var1);

    public T deserialize(Tag var1);

    public boolean validate(Tag var1);

    public static class PrimitiveDataType<T, I extends Tag>
    implements PersistentDataType<T> {
        private final Class<T> implementation;
        private final Class<I> tagClass;
        private final Function<T, I> serializer;
        private final Function<I, T> deserializer;

        @Override
        public Tag serialize(T value) {
            return (Tag)this.serializer.apply(value);
        }

        @Override
        public T deserialize(Tag tag) {
            return this.deserializer.apply(tag);
        }

        @Override
        public boolean validate(Tag tag) {
            return this.tagClass.isAssignableFrom(tag.getClass());
        }

        @Override
        @Generated
        public Class<T> getImplementation() {
            return this.implementation;
        }

        @Generated
        public Class<I> getTagClass() {
            return this.tagClass;
        }

        @Generated
        public Function<T, I> getSerializer() {
            return this.serializer;
        }

        @Generated
        public Function<I, T> getDeserializer() {
            return this.deserializer;
        }

        @Generated
        public PrimitiveDataType(Class<T> implementation, Class<I> tagClass, Function<T, I> serializer, Function<I, T> deserializer) {
            this.implementation = implementation;
            this.tagClass = tagClass;
            this.serializer = serializer;
            this.deserializer = deserializer;
        }
    }
}

