/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.persistence;

import cn.nukkit.level.persistence.PersistentDataType;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.Tag;

public interface PersistentDataContainer {
    public static final String STORAGE_TAG = "persistent_storage";

    public CompoundTag getStorage();

    default public CompoundTag getReadStorage() {
        return this.getStorage();
    }

    public void setStorage(CompoundTag var1);

    default public <T> void set(String key, PersistentDataType<T> type, T value) {
        if (value == null) {
            this.remove(key);
        } else {
            this.getStorage().put(key, type.serialize(value));
            this.write();
        }
    }

    default public boolean has(String key, PersistentDataType<?> type) {
        Tag tag = this.getReadStorage().get(key);
        return tag != null && type.validate(tag);
    }

    default public <T> T get(String key, PersistentDataType<T> type) {
        Tag tag = this.getReadStorage().get(key);
        if (tag != null && type.validate(tag)) {
            return type.deserialize(tag);
        }
        if (tag != null) {
            this.remove(key);
        }
        return null;
    }

    default public void write() {
    }

    default public void remove(String key) {
        if (this.getReadStorage().contains(key)) {
            this.getStorage().remove(key);
            this.write();
        }
    }

    default public void clearStorage() {
        this.setStorage(new CompoundTag());
    }

    default public boolean isEmpty() {
        return this.getReadStorage().isEmpty();
    }
}

