/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.particle;

import cn.nukkit.level.particle.Particle;
import cn.nukkit.math.Vector3;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.LevelEventPacket;
import cn.nukkit.utils.BlockColor;

public class SpellParticle
extends Particle {
    protected final int data;

    public SpellParticle(Vector3 pos) {
        this(pos, 0);
    }

    public SpellParticle(Vector3 pos, int data) {
        super(pos.x, pos.y, pos.z);
        this.data = data;
    }

    public SpellParticle(Vector3 pos, BlockColor blockColor) {
        this(pos, blockColor.getRed(), blockColor.getGreen(), blockColor.getBlue());
    }

    public SpellParticle(Vector3 pos, int r, int g2, int b) {
        this(pos, r, g2, b, 0);
    }

    protected SpellParticle(Vector3 pos, int r, int g2, int b, int a) {
        this(pos, (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g2 & 0xFF) << 8 | b & 0xFF);
    }

    @Override
    public DataPacket[] encode() {
        LevelEventPacket packet = new LevelEventPacket();
        packet.evid = 2002;
        packet.x = (float)this.x;
        packet.y = (float)this.y;
        packet.z = (float)this.z;
        packet.data = this.data;
        packet.tryEncode();
        return new DataPacket[]{packet};
    }
}

