/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.particle;

import cn.nukkit.entity.Entity;
import cn.nukkit.entity.data.EntityMetadata;
import cn.nukkit.level.Level;
import cn.nukkit.level.Location;
import cn.nukkit.level.particle.Particle;
import cn.nukkit.math.Vector3;
import cn.nukkit.network.protocol.AddEntityPacket;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.RemoveEntityPacket;
import cn.nukkit.network.protocol.SetEntityDataPacket;
import com.google.common.base.Strings;
import java.util.ArrayList;

public class FloatingTextParticle
extends Particle {
    protected final Level level;
    protected long entityId = -1L;
    protected boolean invisible = false;
    protected String title;
    protected String text;
    protected EntityMetadata metadata = new EntityMetadata();

    public FloatingTextParticle(Location location, String title) {
        this(location, title, null);
    }

    public FloatingTextParticle(Location location, String title, String text) {
        this(location.getLevel(), location, title, text);
    }

    public FloatingTextParticle(Vector3 pos, String title) {
        this(pos, title, null);
    }

    public FloatingTextParticle(Vector3 pos, String title, String text) {
        this(null, pos, title, text);
    }

    private FloatingTextParticle(Level level, Vector3 pos, String title, String text) {
        super(pos.x, pos.y, pos.z);
        this.level = level;
        this.title = title;
        this.text = text;
        long flags = 0L;
        flags ^= 0x10000L;
        this.metadata.putLong(0, flags ^= 0x4000L).putLong(37, -1L).putByte(81, 1).putFloat(38, 0.01f).putFloat(54, 0.01f).putFloat(53, 0.01f);
        this.updateNameTag();
    }

    public String getText() {
        return this.text == null ? "" : this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.updateNameTag();
        this.sendMetadata();
    }

    public String getTitle() {
        return this.title == null ? "" : this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.updateNameTag();
        this.sendMetadata();
    }

    private void updateNameTag() {
        boolean hasTitle = !Strings.isNullOrEmpty(this.title);
        boolean hasText = !Strings.isNullOrEmpty(this.text);
        String tag = "";
        if (hasTitle) {
            tag = tag + this.title;
            if (hasText) {
                tag = tag + "\n";
            }
        }
        if (hasText) {
            tag = tag + this.text;
        }
        this.metadata.putString(4, tag);
    }

    private void sendMetadata() {
        if (this.level != null) {
            SetEntityDataPacket packet = new SetEntityDataPacket();
            packet.eid = this.entityId;
            packet.metadata = this.metadata;
            this.level.addChunkPacket(this.getChunkX(), this.getChunkZ(), packet);
        }
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
        if (this.level != null) {
            if (invisible) {
                this.level.addChunkPacket(this.getChunkX(), this.getChunkZ(), this.getRemovePacket());
            } else {
                this.level.addChunkPacket(this.getChunkX(), this.getChunkZ(), this.getAddPacket());
            }
        }
    }

    public void setInvisible() {
        this.setInvisible(true);
    }

    public long getEntityId() {
        return this.entityId;
    }

    @Override
    public DataPacket[] encode() {
        ArrayList<DataPacket> packets = new ArrayList<DataPacket>();
        if (this.entityId == -1L) {
            this.entityId = Entity.entityCount++;
        } else {
            packets.add(this.getRemovePacket());
        }
        if (!this.invisible) {
            packets.add(this.getAddPacket());
        }
        return packets.toArray(new DataPacket[0]);
    }

    private AddEntityPacket getAddPacket() {
        AddEntityPacket pk = new AddEntityPacket();
        pk.id = "minecraft:armor_stand";
        pk.entityUniqueId = this.entityId;
        pk.entityRuntimeId = this.entityId;
        pk.x = (float)this.x;
        pk.y = (float)this.y - 0.75f;
        pk.z = (float)this.z;
        pk.metadata = this.metadata;
        return pk;
    }

    private RemoveEntityPacket getRemovePacket() {
        RemoveEntityPacket pk = new RemoveEntityPacket();
        pk.eid = this.entityId;
        return pk;
    }
}

