/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.task;

import cn.nukkit.Server;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.level.generator.Generator;
import cn.nukkit.level.generator.SimpleChunkManager;
import cn.nukkit.scheduler.AsyncTask;

public class PopulationTask
extends AsyncTask {
    private final long seed;
    private final Level level;
    private boolean state = true;
    private BaseFullChunk centerChunk;
    private boolean isPopulated;
    public final BaseFullChunk[] chunks = new BaseFullChunk[9];

    public PopulationTask(Level level, BaseFullChunk chunk) {
        this.level = level;
        this.centerChunk = chunk;
        this.seed = level.getSeed();
        this.chunks[4] = chunk;
        int i = 0;
        for (int z = -1; z <= 1; ++z) {
            int x = -1;
            while (x <= 1) {
                if (i != 4) {
                    BaseFullChunk ck;
                    this.chunks[i] = ck = level.getChunk(chunk.getX() + x, chunk.getZ() + z, true);
                }
                ++x;
                ++i;
            }
        }
    }

    @Override
    public void onRun() {
        this.syncGen(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncGen(int i) {
        if (i == this.chunks.length) {
            this.generationTask();
        } else {
            BaseFullChunk chunk = this.chunks[i];
            if (chunk != null) {
                BaseFullChunk baseFullChunk = chunk;
                synchronized (baseFullChunk) {
                    this.syncGen(i + 1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void generationTask() {
        this.state = false;
        Generator generator = this.level.getGenerator();
        if (generator == null) {
            Server.getInstance().getLogger().debug(this.level.getFolderName() + "/PopulationTask: generator == null");
            return;
        }
        SimpleChunkManager manager = (SimpleChunkManager)generator.getChunkManager();
        if (manager == null) {
            Server.getInstance().getLogger().debug(this.level.getFolderName() + "/PopulationTask: manager == null");
            return;
        }
        SimpleChunkManager simpleChunkManager = manager;
        synchronized (simpleChunkManager) {
            try {
                int z;
                BaseFullChunk[] x2;
                manager.cleanChunks(this.seed);
                BaseFullChunk centerChunk = this.centerChunk;
                if (centerChunk == null) {
                    return;
                }
                int index = 0;
                int x2 = -1;
                while (true) {
                    if (x2 < 2) {
                    } else {
                        x2 = this.chunks;
                        z = x2.length;
                        break;
                    }
                    for (z = -1; z < 2; ++z, ++index) {
                        BaseFullChunk ck = this.chunks[index];
                        if (ck == centerChunk) continue;
                        if (this.level.getProvider() == null) {
                            this.state = false;
                            Server.getInstance().getLogger().debug(this.level.getFolderName() + "/PopulationTask: provider == null");
                            return;
                        }
                        this.chunks[index] = ck == null ? this.level.getProvider().getEmptyChunk(centerChunk.getX() + x2, centerChunk.getZ() + z) : ck;
                    }
                    ++x2;
                }
                for (int ck = 0; ck < z; ++ck) {
                    BaseFullChunk chunk = x2[ck];
                    if (this.level.getProvider() == null) {
                        this.state = false;
                        Server.getInstance().getLogger().debug(this.level.getFolderName() + "/PopulationTask: provider == null");
                        return;
                    }
                    manager.setChunk(chunk.getX(), chunk.getZ(), chunk);
                    if (chunk.isGenerated()) continue;
                    generator.generateChunk(chunk.getX(), chunk.getZ());
                    BaseFullChunk newChunk = manager.getChunk(chunk.getX(), chunk.getZ());
                    newChunk.setGenerated();
                    if (newChunk == chunk) continue;
                    manager.setChunk(chunk.getX(), chunk.getZ(), newChunk);
                }
                if (this.level.getProvider() == null) {
                    this.state = false;
                    Server.getInstance().getLogger().debug(this.level.getFolderName() + "/PopulationTask: provider == null");
                    return;
                }
                this.isPopulated = centerChunk.isPopulated();
                if (!this.isPopulated) {
                    generator.populateChunk(centerChunk.getX(), centerChunk.getZ());
                    centerChunk = manager.getChunk(centerChunk.getX(), centerChunk.getZ());
                    centerChunk.setPopulated();
                    centerChunk.recalculateHeightMap();
                    centerChunk.populateSkyLight();
                    centerChunk.setLightPopulated();
                    this.centerChunk = centerChunk;
                }
                manager.setChunk(centerChunk.getX(), centerChunk.getZ());
                index = 0;
                for (int x3 = -1; x3 < 2; ++x3) {
                    for (z = -1; z < 2; ++z, ++index) {
                        this.chunks[index] = null;
                        BaseFullChunk newChunk = manager.getChunk(centerChunk.getX() + x3, centerChunk.getZ() + z);
                        if (newChunk == null || !newChunk.hasChanged()) continue;
                        this.chunks[index] = newChunk;
                    }
                }
                this.state = true;
            }
            finally {
                manager.cleanChunks(this.seed);
            }
            return;
        }
    }

    @Override
    public void onCompletion(Server server) {
        if (this.level != null) {
            if (!this.state) {
                return;
            }
            BaseFullChunk centerChunk = this.centerChunk;
            if (centerChunk == null) {
                return;
            }
            for (BaseFullChunk chunk : this.chunks) {
                if (chunk == null) continue;
                this.level.generateChunkCallback(chunk.getX(), chunk.getZ(), chunk);
            }
            this.level.generateChunkCallback(centerChunk.getX(), centerChunk.getZ(), centerChunk, this.isPopulated);
        }
    }
}

