/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.populator.tree;

import cn.nukkit.block.Block;
import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.generator.object.tree.ObjectJungleBigTree;
import cn.nukkit.level.generator.populator.type.Populator;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.Vector3;

public class JungleBigTreePopulator
extends Populator {
    private ChunkManager level;
    private int randomAmount;
    private int baseAmount;

    public JungleBigTreePopulator() {
        this(3);
    }

    public JungleBigTreePopulator(int type) {
    }

    public void setRandomAmount(int randomAmount) {
        this.randomAmount = randomAmount;
    }

    public void setBaseAmount(int baseAmount) {
        this.baseAmount = baseAmount;
    }

    @Override
    public void populate(ChunkManager level, int chunkX, int chunkZ, NukkitRandom random, FullChunk chunk) {
        this.level = level;
        int amount = random.nextBoundedInt(this.randomAmount + 1) + this.baseAmount;
        Vector3 v = new Vector3();
        for (int i = 0; i < amount; ++i) {
            int z;
            int x = NukkitMath.randomRange(random, chunkX << 4, (chunkX << 4) + 15);
            int y = this.getHighestWorkableBlock(x, z = NukkitMath.randomRange(random, chunkZ << 4, (chunkZ << 4) + 15));
            if (y == -1) continue;
            new ObjectJungleBigTree(10, 20, Block.get(17, 3), Block.get(18, 3)).generate(this.level, random, v.setComponents(x, y, z));
        }
    }

    private int getHighestWorkableBlock(int x, int z) {
        int b;
        int y;
        for (y = 127; y > 0 && (b = this.level.getBlockIdAt(x, y, z)) != 3 && b != 2; --y) {
            if (b == 0 || b == 78) continue;
            return -1;
        }
        return ++y;
    }
}

