/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.populator.impl;

import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.generator.populator.type.Populator;
import cn.nukkit.math.NukkitRandom;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;

public class PopulatorWeepingVines
extends Populator {
    private static int getHighestEndingBlock(ChunkManager level, int x, int y, int z) {
        while (y > 0) {
            int b = level.getBlockIdAt(x, y, z);
            int above = level.getBlockIdAt(x, y + 1, z);
            if (above == 0 && (b == 87 || b == 487 || b == 214 || b == 11 || b == 10 || b == 483 || b == 478 || b == 153 || b == 543 || b == 526)) break;
            --y;
        }
        return ++y;
    }

    private static IntArrayList getHighestWorkableBlocks(ChunkManager level, int x, int z) {
        IntArrayList blockYs = new IntArrayList();
        for (int y = 128; y > 0; --y) {
            int b = level.getBlockIdAt(x, y, z);
            if (b != 487 && b != 87 || level.getBlockIdAt(x, y - 1, z) != 0) continue;
            blockYs.add(y - 1);
        }
        return blockYs;
    }

    @Override
    public void populate(ChunkManager level, int chunkX, int chunkZ, NukkitRandom random, FullChunk chunk) {
        if (random.nextBoundedInt(8) < 7) {
            return;
        }
        int amount = random.nextBoundedInt(5) + 1;
        for (int i = 0; i < amount; ++i) {
            int x = random.nextRange(chunkX << 4, (chunkX << 4) + 15);
            int z = random.nextRange(chunkZ << 4, (chunkZ << 4) + 15);
            IntArrayList ys = PopulatorWeepingVines.getHighestWorkableBlocks(level, x, z);
            IntListIterator intListIterator = ys.iterator();
            while (intListIterator.hasNext()) {
                int y = (Integer)intListIterator.next();
                if (y <= 1) continue;
                int endY = PopulatorWeepingVines.getHighestEndingBlock(level, x, y, z);
                int amountToDecrease = Math.min(random.nextBoundedInt(y - endY), 10);
                for (int yPos = y; yPos > y - amountToDecrease; --yPos) {
                    level.setBlockAt(x, yPos, z, 486);
                }
            }
        }
    }
}

