/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.populator.impl;

import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.generator.populator.type.Populator;
import cn.nukkit.math.NukkitRandom;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;

public class PopulatorTwistingVines
extends Populator {
    private static int getHighestEndingBlock(ChunkManager level, int x, int y, int z) {
        while (y < 128) {
            int b = level.getBlockIdAt(x, y, z);
            int above = level.getBlockIdAt(x, y + 1, z);
            if (b == 0 && (above == 87 || above == 488 || above == 482 || above == 11 || above == 10 || above == 484 || above == 479 || above == 153 || above == 543 || above == 526)) break;
            ++y;
        }
        return y;
    }

    private static IntArrayList getHighestWorkableBlocks(ChunkManager level, int x, int z) {
        IntArrayList blockYs = new IntArrayList();
        for (int y = 128; y > 0; --y) {
            int b = level.getBlockIdAt(x, y, z);
            if (b != 488 && b != 87 || level.getBlockIdAt(x, y + 1, z) != 0) continue;
            blockYs.add(y + 1);
        }
        return blockYs;
    }

    @Override
    public void populate(ChunkManager level, int chunkX, int chunkZ, NukkitRandom random, FullChunk chunk) {
        if (random.nextBoundedInt(8) < 7) {
            return;
        }
        int amount = random.nextBoundedInt(5) + 2;
        for (int i = 0; i < amount; ++i) {
            int x = random.nextRange(chunkX << 4, (chunkX << 4) + 15);
            int z = random.nextRange(chunkZ << 4, (chunkZ << 4) + 15);
            IntArrayList ys = PopulatorTwistingVines.getHighestWorkableBlocks(level, x, z);
            IntListIterator intListIterator = ys.iterator();
            while (intListIterator.hasNext()) {
                int y = (Integer)intListIterator.next();
                if (y <= 1 || random.nextBoundedInt(4) == 0) continue;
                int endY = PopulatorTwistingVines.getHighestEndingBlock(level, x, y, z);
                int amountToDecrease = Math.min(random.nextBoundedInt(endY - y), 15);
                for (int yPos = y; yPos < y + amountToDecrease / 2; ++yPos) {
                    level.setBlockAt(x, yPos, z, 542);
                }
            }
        }
    }
}

