/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.populator.impl;

import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.generator.populator.helper.EnsureCover;
import cn.nukkit.level.generator.populator.helper.EnsureGrassBelow;
import cn.nukkit.level.generator.populator.type.PopulatorSurfaceBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.NukkitRandom;

public class PopulatorSugarcane
extends PopulatorSurfaceBlock {
    private boolean findWater(int x, int y, int z, FullChunk chunk) {
        int cx = x & 0xF;
        int cz = z & 0xF;
        int b = chunk.getBlockId(NukkitMath.clamp(cx + BlockFace.NORTH.getXOffset(), 0, 15), y, NukkitMath.clamp(cz + BlockFace.NORTH.getZOffset(), 0, 15));
        if (b == 8 || b == 9) {
            return true;
        }
        b = chunk.getBlockId(NukkitMath.clamp(cx + BlockFace.EAST.getXOffset(), 0, 15), y, NukkitMath.clamp(cz + BlockFace.EAST.getZOffset(), 0, 15));
        if (b == 8 || b == 9) {
            return true;
        }
        b = chunk.getBlockId(NukkitMath.clamp(cx + BlockFace.SOUTH.getXOffset(), 0, 15), y, NukkitMath.clamp(cz + BlockFace.SOUTH.getZOffset(), 0, 15));
        if (b == 8 || b == 9) {
            return true;
        }
        b = chunk.getBlockId(NukkitMath.clamp(cx + BlockFace.WEST.getXOffset(), 0, 15), y, NukkitMath.clamp(cz + BlockFace.WEST.getZOffset(), 0, 15));
        return b == 8 || b == 9;
    }

    @Override
    protected boolean canStay(int x, int y, int z, FullChunk chunk) {
        return EnsureCover.ensureCover(x, y, z, chunk) && EnsureGrassBelow.ensureGrassOrSandBelow(x, y, z, chunk) && this.findWater(x, y - 1, z, chunk);
    }

    @Override
    protected int getBlockId(int x, int z, NukkitRandom random, FullChunk chunk) {
        return 5313;
    }
}

