/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.populator.impl;

import cn.nukkit.block.Block;
import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.format.LevelProvider;
import cn.nukkit.level.generator.populator.type.Populator;
import cn.nukkit.math.NukkitRandom;

public class PopulatorSpring
extends Populator {
    private final int block;
    private final int replaceId;
    private final int attempts;
    private final int minHeight;
    private final int maxHeight;

    public PopulatorSpring(int block, int replaceId, int attempts, int minHeight, int maxHeight) {
        this.block = block;
        this.replaceId = replaceId;
        this.attempts = attempts;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
    }

    @Override
    public void populate(ChunkManager level, int chunkX, int chunkZ, NukkitRandom random, FullChunk chunk) {
        int sourceX = chunkX << 4;
        int sourceZ = chunkZ << 4;
        for (int i = 0; i < this.attempts; ++i) {
            int blockXY_1Z;
            int blockXY1Z;
            int block_1XYZ;
            int block1XYZ;
            int blockX1YZ;
            int blockX_1YZ;
            int x = sourceX + random.nextBoundedInt(16);
            int z = sourceZ + random.nextBoundedInt(16);
            int y = random.nextRange(this.minHeight, this.maxHeight);
            int blockXYZ = level.getBlockIdAt(x, y, z);
            if (blockXYZ != 0 && blockXYZ != this.replaceId || (blockX_1YZ = level.getBlockIdAt(x, y - 1, z)) == 12 || blockX_1YZ == 13 || (blockX1YZ = level.getBlockIdAt(x, y + 1, z)) == 12 || blockX1YZ == 13 || blockX_1YZ != this.replaceId && blockX1YZ != this.replaceId || (block1XYZ = level.getBlockIdAt(x + 1, y, z)) == 12 || block1XYZ == 13 || (block_1XYZ = level.getBlockIdAt(x - 1, y, z)) == 12 || block_1XYZ == 13 || (blockXY1Z = level.getBlockIdAt(x, y, z + 1)) == 12 || blockXY1Z == 13 || (blockXY_1Z = level.getBlockIdAt(x, y, z - 1)) == 12 || blockXY_1Z == 13) continue;
            int surroundCount = 0;
            if (block1XYZ == this.replaceId) {
                ++surroundCount;
            }
            if (block_1XYZ == this.replaceId) {
                ++surroundCount;
            }
            if (blockXY1Z == this.replaceId) {
                ++surroundCount;
            }
            if (blockXY_1Z == this.replaceId) {
                ++surroundCount;
            }
            if (surroundCount != 3) continue;
            int airCount = 0;
            if (block1XYZ == 0) {
                ++airCount;
            }
            if (block_1XYZ == 0) {
                ++airCount;
            }
            if (blockXY1Z == 0) {
                ++airCount;
            }
            if (blockXY_1Z == 0) {
                ++airCount;
            }
            if (airCount != 1) continue;
            level.setBlockAt(x, y, z, this.block);
            LevelProvider provider = chunk.getProvider();
            if (provider == null) continue;
            Block state = Block.fullList[this.block << 6].clone();
            state.x = x;
            state.y = y;
            state.z = z;
            state.level = provider.getLevel();
            if (state.level == null) continue;
            state.level.scheduleUpdate(state, state, 1, 0, false);
        }
    }
}

