/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.populator.impl;

import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.generator.populator.type.Populator;
import cn.nukkit.math.NukkitRandom;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;

public class PopulatorSoulSandValleyGround
extends Populator {
    private static IntArrayList getHighestWorkableBlocks(ChunkManager level, int x, int z) {
        IntArrayList blockYs = new IntArrayList();
        for (int y = 127; y > 0; --y) {
            int b = level.getBlockIdAt(x, y, z);
            if (b != 491 && b != 88 || level.getBlockIdAt(x, y + 1, z) != 0) continue;
            blockYs.add(y + 1);
        }
        return blockYs;
    }

    @Override
    public void populate(ChunkManager level, int chunkX, int chunkZ, NukkitRandom random, FullChunk chunk) {
        if (random.nextBoundedInt(15) != 1) {
            return;
        }
        int block = random.nextBoolean() ? 478 : (random.nextBoolean() ? 40 : 39);
        int amount = random.nextBoundedInt(7) + 3;
        for (int i = 0; i < amount; ++i) {
            int x = random.nextRange(chunkX << 4, (chunkX << 4) + 15);
            int z = random.nextRange(chunkZ << 4, (chunkZ << 4) + 15);
            IntArrayList ys = PopulatorSoulSandValleyGround.getHighestWorkableBlocks(level, x, z);
            IntListIterator intListIterator = ys.iterator();
            while (intListIterator.hasNext()) {
                int y = (Integer)intListIterator.next();
                if (y <= 1) continue;
                level.setBlockAt(x, y, z, block);
            }
        }
    }
}

