/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.populator.impl;

import cn.nukkit.block.BlockLayer;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.format.anvil.Chunk;
import cn.nukkit.level.generator.populator.helper.EnsureCover;
import cn.nukkit.level.generator.populator.type.PopulatorOceanFloorSurfaceBlock;
import cn.nukkit.math.NukkitRandom;

public class PopulatorSeagrass
extends PopulatorOceanFloorSurfaceBlock {
    @Override
    protected boolean canStay(int x, int y, int z, FullChunk chunk) {
        int down;
        if (chunk instanceof Chunk) {
            return false;
        }
        return EnsureCover.ensureWaterCover(x, y, z, chunk) && ((down = chunk.getBlockId(x, y - 1, z)) == 3 || down == 12 || down == 13);
    }

    @Override
    protected int getBlockId(int x, int z, NukkitRandom random, FullChunk chunk) {
        return 24640;
    }

    @Override
    protected void placeBlock(int x, int y, int z, int id, FullChunk chunk, NukkitRandom random) {
        if (y < 255 && random.nextDouble() < 0.3 && chunk.getBlockId(x, y + 1, z) == 9) {
            chunk.setBlock(x, y, z, 385, 2);
            chunk.setBlock(x, y + 1, z, 385, 1);
            chunk.setFullBlockId(x, y, z, BlockLayer.WATERLOGGED, 576);
            chunk.setFullBlockId(x, y + 1, z, BlockLayer.WATERLOGGED, 576);
        } else {
            chunk.setFullBlockId(x, y, z, id);
            chunk.setFullBlockId(x, y, z, BlockLayer.WATERLOGGED, 576);
        }
    }
}

