/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.populator.impl;

import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.generator.populator.type.Populator;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.utils.Utils;

public class PopulatorPumpkin
extends Populator {
    @Override
    public void populate(ChunkManager level, int chunkX, int chunkZ, NukkitRandom random, FullChunk chunk) {
        int z;
        int x;
        int y;
        if (Utils.rand(0, 10) == 5 && (y = PopulatorPumpkin.getHighestWorkableBlock(chunk, x = random.nextRange(0, 15), z = random.nextRange(0, 15))) != -1 && PopulatorPumpkin.canPumpkinStay(chunk, x, y, z)) {
            chunk.setBlock(x, y, z, 86);
        }
    }

    private static boolean canPumpkinStay(FullChunk chunk, int x, int y, int z) {
        int b = chunk.getBlockId(x, y, z);
        return b == 0 && chunk.getBlockId(x, y - 1, z) == 2;
    }

    private static int getHighestWorkableBlock(FullChunk chunk, int x, int z) {
        int b;
        int y;
        for (y = 0; y <= 127 && (b = chunk.getBlockId(x, y, z)) != 0; ++y) {
        }
        return y == 0 ? -1 : y;
    }
}

