/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.populator.impl;

import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.biome.Biome;
import cn.nukkit.level.biome.EnumBiome;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.generator.populator.type.Populator;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.NukkitRandom;

public class PopulatorGlowStone
extends Populator {
    @Override
    public void populate(ChunkManager level, int chunkX, int chunkZ, NukkitRandom random, FullChunk chunk) {
        if (random.nextBoundedInt(9) < 8 || Biome.getBiome(chunk.getBiomeId(7, 7)).getId() == EnumBiome.SOULSAND_VALLEY.id) {
            return;
        }
        int x = NukkitMath.randomRange(random, chunkX << 4, (chunkX << 4) + 15);
        int z = NukkitMath.randomRange(random, chunkZ << 4, (chunkZ << 4) + 15);
        int y = PopulatorGlowStone.getHighestWorkableBlock(chunk, x & 0xF, z & 0xF) + 1;
        boolean vertical = random.nextBoolean();
        if (y != -1) {
            int size = random.nextRange(3, 6);
            int count = NukkitMath.randomRange(random, 20 + (size << 1), 30 + (size << 1));
            if (vertical && size > 3) {
                --size;
            }
            for (int i = 0; i < count; ++i) {
                int zz;
                int xx;
                int yy = y + (random.nextBoundedInt(size) - random.nextRange(3, vertical ? 5 : 3));
                if (yy <= 0 || chunk.getBlockId((xx = x + (random.nextBoundedInt(size) - 3)) & 0xF, yy & 0xFF, (zz = z + (random.nextBoundedInt(size) - 3)) & 0xF) != 0) continue;
                level.setBlockAt(xx, yy, zz, 89);
            }
        }
    }

    private static int getHighestWorkableBlock(FullChunk chunk, int x, int z) {
        int b;
        int y;
        for (y = 120; y >= 0 && (b = chunk.getBlockId(x, y, z)) != 0; --y) {
        }
        return y == 0 ? -1 : y;
    }
}

