/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.populator.impl;

import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.generator.populator.helper.EnsureCover;
import cn.nukkit.level.generator.populator.helper.EnsureGrassBelow;
import cn.nukkit.level.generator.populator.type.PopulatorSurfaceBlock;
import cn.nukkit.math.NukkitRandom;

public class PopulatorForestRock
extends PopulatorSurfaceBlock {
    @Override
    protected boolean canStay(int x, int y, int z, FullChunk chunk) {
        return EnsureCover.ensureCover(x, y, z, chunk) && EnsureGrassBelow.ensureGrassBelow(x, y, z, chunk);
    }

    @Override
    protected int getBlockId(int x, int z, NukkitRandom random, FullChunk chunk) {
        return 3072;
    }

    @Override
    protected void populateCount(ChunkManager level, int chunkX, int chunkZ, NukkitRandom random, FullChunk chunk) {
        int radiusY;
        int radiusZ;
        int radiusX = random.nextBoundedInt(2);
        float f = (float)(radiusX + (radiusZ = random.nextBoundedInt(2)) + (radiusY = random.nextBoundedInt(2))) * 0.333f + 0.5f;
        float fsquared = f * f;
        if ((double)fsquared <= 0.7) {
            return;
        }
        int rx = random.nextBoundedInt(16);
        int rz = random.nextBoundedInt(16);
        int sourceX = (chunkX << 4) + rx;
        int sourceZ = (chunkZ << 4) + rz;
        int sourceY = this.getHighestWorkableBlock(level, rx, rz, chunk);
        boolean groundReached = false;
        while (sourceY > 3) {
            int block;
            if ((block = level.getBlockIdAt(sourceX, --sourceY, sourceZ)) == 0 || block != 243 && block != 2 && block != 3 && block != 1) continue;
            groundReached = true;
            ++sourceY;
            break;
        }
        if (!groundReached || level.getBlockIdAt(sourceX, sourceY, sourceZ) != 0) {
            return;
        }
        for (int x = -radiusX; x <= radiusX; ++x) {
            float xsquared = x * x;
            for (int z = -radiusZ; z <= radiusZ; ++z) {
                float zsquared = z * z;
                for (int y = -radiusY; y <= radiusY; ++y) {
                    int bid;
                    if (xsquared + zsquared + (float)(y * y) > fsquared || (bid = level.getBlockIdAt(sourceX + x, sourceY + y, sourceZ + z)) != 0 && bid != 243 && bid != 2 && bid != 3 && bid != 1) continue;
                    level.setBlockFullIdAt(sourceX + x, sourceY + y, sourceZ + z, 3072);
                }
            }
        }
    }
}

