/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.populator.impl;

import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.generator.populator.type.Populator;
import cn.nukkit.math.NukkitRandom;

public class PopulatorBedrock
extends Populator {
    private final boolean nether;

    public PopulatorBedrock() {
        this(false);
    }

    public PopulatorBedrock(boolean nether) {
        this.nether = nether;
    }

    @Override
    public void populate(ChunkManager level, int chunkX, int chunkZ, NukkitRandom random, FullChunk chunk) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int i;
                chunk.setBlockId(x, 0, z, 7);
                for (i = 1; i < 5; ++i) {
                    if (random.nextBoundedInt(i) != 0) continue;
                    chunk.setBlockId(x, i, z, 7);
                }
                if (!this.nether) continue;
                chunk.setBlockId(x, 127, z, 7);
                for (i = 126; i > 122; --i) {
                    if (random.nextBoundedInt(127 - i) != 0) continue;
                    chunk.setBlockId(x, i, z, 7);
                }
            }
        }
    }
}

