/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.populator.impl;

import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.generator.populator.type.Populator;
import cn.nukkit.math.NukkitRandom;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;

public class PopulatorBasaltDeltaPillar
extends Populator {
    private static IntArrayList getHighestWorkableBlocks(ChunkManager level, int x, int z) {
        IntArrayList blockYs = new IntArrayList();
        for (int y = 128; y > 0; --y) {
            int b = level.getBlockIdAt(x, y, z);
            if (b != 489 && b != 528 || level.getBlockIdAt(x, y + 1, z) != 0) continue;
            blockYs.add(y + 1);
        }
        return blockYs;
    }

    @Override
    public void populate(ChunkManager level, int chunkX, int chunkZ, NukkitRandom random, FullChunk chunk) {
        int amount = random.nextBoundedInt(128) + 128;
        IntArrayList visited = new IntArrayList();
        for (int i = 0; i < amount; ++i) {
            int z;
            int x = random.nextRange(chunkX << 4, (chunkX << 4) + 15);
            int pos = (x >> 1) + ((z = random.nextRange(chunkZ << 4, (chunkZ << 4) + 15)) << 1);
            if (visited.contains(pos)) continue;
            IntArrayList ys = PopulatorBasaltDeltaPillar.getHighestWorkableBlocks(level, x, z);
            IntListIterator intListIterator = ys.iterator();
            while (intListIterator.hasNext()) {
                int y = (Integer)intListIterator.next();
                if (y <= 1 || random.nextBoundedInt(5) == 0) continue;
                for (int randomHeight = 0; randomHeight < random.nextBoundedInt(5) + 1; ++randomHeight) {
                    int placeLocation = y + randomHeight;
                    level.setBlockAt(x, placeLocation, z, 489);
                }
                visited.add(pos);
            }
        }
    }
}

