/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.populator.impl;

import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.generator.populator.type.Populator;
import cn.nukkit.math.NukkitRandom;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;

public class PopulatorBasaltDeltaLava
extends Populator {
    private static IntArrayList getHighestWorkableBlocks(ChunkManager level, int x, int z) {
        IntArrayList blockYs = new IntArrayList();
        for (int y = 128; y > 0; --y) {
            int b = level.getBlockIdAt(x, y, z);
            if (b != 489 && b != 528 || level.getBlockIdAt(x, y + 1, z) != 0 || level.getBlockIdAt(x + 1, y, z) == 0 || level.getBlockIdAt(x - 1, y, z) == 0 || level.getBlockIdAt(x, y, z + 1) == 0 || level.getBlockIdAt(x, y, z - 1) == 0) continue;
            blockYs.add(y);
        }
        return blockYs;
    }

    @Override
    public void populate(ChunkManager level, int chunkX, int chunkZ, NukkitRandom random, FullChunk chunk) {
        int amount = random.nextBoundedInt(64) + 64;
        for (int i = 0; i < amount; ++i) {
            int x = random.nextRange(chunkX << 4, (chunkX << 4) + 15);
            int z = random.nextRange(chunkZ << 4, (chunkZ << 4) + 15);
            IntArrayList ys = PopulatorBasaltDeltaLava.getHighestWorkableBlocks(level, x, z);
            IntListIterator intListIterator = ys.iterator();
            while (intListIterator.hasNext()) {
                int y = (Integer)intListIterator.next();
                if (y <= 1) continue;
                level.setBlockAt(x, y, z, 11);
            }
        }
    }
}

