/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.populator.impl;

import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.format.anvil.Chunk;
import cn.nukkit.level.generator.populator.helper.EnsureCover;
import cn.nukkit.level.generator.populator.helper.EnsureGrassBelow;
import cn.nukkit.level.generator.populator.type.PopulatorSurfaceBlock;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.utils.Utils;

public class PopulatorBamboo
extends PopulatorSurfaceBlock {
    @Override
    protected boolean canStay(int x, int y, int z, FullChunk chunk) {
        if (chunk instanceof Chunk) {
            return false;
        }
        return EnsureCover.ensureCover(x, y, z, chunk) && EnsureGrassBelow.ensureGrassBelow(x, y, z, chunk);
    }

    @Override
    protected int getBlockId(int x, int z, NukkitRandom random, FullChunk chunk) {
        return 26752;
    }

    @Override
    protected void placeBlock(int x, int y, int z, int id, FullChunk chunk, NukkitRandom random) {
        int yy;
        int part;
        int height = Utils.rand(1, 10);
        for (part = 0; part < height && (yy = y + part) < 256 && chunk.getBlockId(x, yy, z) == 0; ++part) {
            super.placeBlock(x, yy, z, id, chunk, random);
        }
        yy = y + part;
        if (yy < 256 && chunk.getBlockId(x, yy, z) == 0) {
            chunk.setBlock(x, yy, z, 418, 2);
        } else {
            chunk.setBlock(x, yy - 1, z, 418, 2);
        }
    }
}

