/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.populator.impl;

import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.generator.object.mushroom.BigMushroom;
import cn.nukkit.level.generator.populator.type.PopulatorCount;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.Vector3;

public class MushroomPopulator
extends PopulatorCount {
    private final int type;

    public MushroomPopulator() {
        this(-1);
    }

    public MushroomPopulator(int type) {
        this.type = type;
    }

    @Override
    public void populateCount(ChunkManager level, int chunkX, int chunkZ, NukkitRandom random, FullChunk chunk) {
        int z;
        int x = chunkX << 4 | random.nextBoundedInt(16);
        int y = this.getHighestWorkableBlock(level, x, z = chunkZ << 4 | random.nextBoundedInt(16), chunk);
        if (y != -1) {
            new BigMushroom(this.type).generate(level, random, new Vector3(x, y, z));
        }
    }

    @Override
    protected int getHighestWorkableBlock(ChunkManager level, int x, int z, FullChunk chunk) {
        int b;
        int y;
        x &= 0xF;
        z &= 0xF;
        for (y = 254; y > 0 && (b = chunk.getBlockId(x, y, z)) != 3 && b != 2 && b != 110; --y) {
            if (b == 0 || b == 78) continue;
            return -1;
        }
        return ++y;
    }
}

