/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.object.tree;

import cn.nukkit.block.Block;
import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.Level;
import cn.nukkit.level.generator.object.tree.ObjectTree;
import cn.nukkit.math.NukkitRandom;
import java.util.concurrent.ThreadLocalRandom;

public abstract class ObjectNetherTree
extends ObjectTree {
    private final int treeHeight;

    public ObjectNetherTree() {
        this(ThreadLocalRandom.current().nextInt(9) + 4);
    }

    public ObjectNetherTree(int treeHeight) {
        this.treeHeight = treeHeight;
    }

    @Override
    public int getTreeHeight() {
        return this.treeHeight;
    }

    @Override
    public void placeObject(ChunkManager level, int x, int y, int z, NukkitRandom random) {
        int zz;
        int xx;
        int yy;
        int maxBlockY;
        int n = maxBlockY = level instanceof Level ? ((Level)level).getMaxBlockY() : 255;
        if (y >= maxBlockY) {
            return;
        }
        this.placeTrunk(level, x, y, z, random, this.getTreeHeight());
        int mid = 2;
        for (yy = y - 3 + this.treeHeight; yy <= y + this.treeHeight - 1; ++yy) {
            if (yy >= maxBlockY) continue;
            for (xx = x - mid; xx <= x + mid; ++xx) {
                int xOff = Math.abs(xx - x);
                for (int zz2 = z - mid; zz2 <= z + mid; zz2 += mid * 2) {
                    int zOff = Math.abs(zz2 - z);
                    if (xOff == mid && zOff == mid && random.nextBoundedInt(2) == 0 || Block.isBlockSolidById(level.getBlockIdAt(xx, yy, zz2))) continue;
                    if (random.nextBoundedInt(20) == 0) {
                        level.setBlockAt(xx, yy, zz2, 485);
                        continue;
                    }
                    level.setBlockAt(xx, yy, zz2, this.getLeafBlock());
                }
            }
            for (zz = z - mid; zz <= z + mid; ++zz) {
                int zOff = Math.abs(zz - z);
                for (int xx2 = x - mid; xx2 <= x + mid; xx2 += mid * 2) {
                    int xOff = Math.abs(xx2 - x);
                    if (xOff == mid && zOff == mid && random.nextBoundedInt(2) == 0 || Block.isBlockSolidById(level.getBlockIdAt(xx2, yy, zz))) continue;
                    if (random.nextBoundedInt(20) == 0) {
                        level.setBlockAt(xx2, yy, zz, 485);
                        continue;
                    }
                    level.setBlockAt(xx2, yy, zz, this.getLeafBlock());
                }
            }
        }
        for (yy = y - 4 + this.treeHeight; yy <= y + this.treeHeight - 3; ++yy) {
            int i;
            if (yy >= maxBlockY) continue;
            for (xx = x - mid; xx <= x + mid; ++xx) {
                for (int zz3 = z - mid; zz3 <= z + mid; zz3 += mid * 2) {
                    if (Block.isBlockSolidById(level.getBlockIdAt(xx, yy, zz3)) || random.nextBoundedInt(3) != 0) continue;
                    for (i = 0; i < random.nextBoundedInt(5); ++i) {
                        if (Block.isBlockSolidById(level.getBlockIdAt(xx, yy - i, zz3))) continue;
                        level.setBlockAt(xx, yy - i, zz3, this.getLeafBlock());
                    }
                }
            }
            for (zz = z - mid; zz <= z + mid; ++zz) {
                for (int xx3 = x - mid; xx3 <= x + mid; xx3 += mid * 2) {
                    if (Block.isBlockSolidById(level.getBlockIdAt(xx3, yy, zz)) || random.nextBoundedInt(3) != 0) continue;
                    for (i = 0; i < random.nextBoundedInt(4); ++i) {
                        if (Block.isBlockSolidById(level.getBlockIdAt(xx3, yy - i, zz))) continue;
                        level.setBlockAt(xx3, yy - i, zz, this.getLeafBlock());
                    }
                }
            }
        }
        for (int xCanopy = x - mid + 1; xCanopy <= x + mid - 1; ++xCanopy) {
            for (int zCanopy = z - mid + 1; zCanopy <= z + mid - 1; ++zCanopy) {
                if (Block.isBlockSolidById(level.getBlockIdAt(xCanopy, y + this.treeHeight, zCanopy))) continue;
                level.setBlockAt(xCanopy, y + this.treeHeight, zCanopy, this.getLeafBlock());
            }
        }
    }

    @Override
    protected void placeTrunk(ChunkManager level, int x, int y, int z, NukkitRandom random, int trunkHeight) {
        int maxBlockY = level instanceof Level ? ((Level)level).getMaxBlockY() : 255;
        level.setBlockAt(x, y, z, this.getTrunkBlock());
        for (int yy = 0; yy < trunkHeight; ++yy) {
            int blockId;
            if (y + yy >= maxBlockY || !this.overridable(blockId = level.getBlockIdAt(x, y + yy, z))) continue;
            level.setBlockAt(x, y + yy, z, this.getTrunkBlock());
        }
    }
}

