/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.object;

import cn.nukkit.block.BlockLayer;
import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.Level;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.Utils;

public class ObjectTallGrass {
    public static void growGrass(ChunkManager level, Vector3 pos, NukkitRandom random) {
        ObjectTallGrass.growGrass(level, pos);
    }

    public static void growGrass(ChunkManager level, Vector3 pos) {
        int maxBlockY = level instanceof Level ? ((Level)level).getMaxBlockY() : 255;
        int minBlockY = level instanceof Level ? ((Level)level).getMinBlockY() : 0;
        block0: for (int i = 0; i < 128; ++i) {
            int num = 0;
            int x = pos.getFloorX();
            int y = pos.getFloorY() + 1;
            int z = pos.getFloorZ();
            while (true) {
                if (num >= i >> 4) {
                    if (level.getBlockIdAt(x, y, z) != 0) continue block0;
                    if (Utils.random.nextInt(8) == 0) {
                        if (Utils.rand()) {
                            level.setBlockAt(x, y, z, 37);
                            continue block0;
                        }
                        if (Utils.rand()) {
                            level.setBlockAt(x, y, z, 31, 2);
                            continue block0;
                        }
                        level.setBlockAt(x, y, z, 38);
                        continue block0;
                    }
                    level.setBlockAt(x, y, z, 31, 1);
                    continue block0;
                }
                if ((y += Utils.rand(-1, 1) * Utils.random.nextInt(3) >> 1) > maxBlockY || y < minBlockY || level.getBlockIdAt(x += Utils.rand(-1, 1), y - 1, z += Utils.rand(-1, 1)) != 2) continue block0;
                ++num;
            }
        }
    }

    public static void growSeagrass(ChunkManager level, Vector3 pos) {
        int maxBlockY = level instanceof Level ? ((Level)level).getMaxBlockY() : 255;
        int minBlockY = level instanceof Level ? ((Level)level).getMinBlockY() : 0;
        block0: for (int i = 0; i < 48; ++i) {
            int num = 0;
            int x = pos.getFloorX();
            int y = pos.getFloorY() + 1;
            int z = pos.getFloorZ();
            while (true) {
                int block;
                if (num >= i >> 4) {
                    block = level.getBlockIdAt(x, y, z);
                    if (block != 8 && block != 9) continue block0;
                    level.setBlockAt(x, y, z, 385, 0);
                    level.setBlockAtLayer(x, y, z, BlockLayer.WATERLOGGED, 8, 0);
                    continue block0;
                }
                if ((y += Utils.rand(-1, 1) * Utils.random.nextInt(3) >> 1) > maxBlockY || y < minBlockY || (block = level.getBlockIdAt(x += Utils.rand(-1, 1), y - 1, z += Utils.rand(-1, 1))) != 3 && block != 12 && block != 13) continue block0;
                ++num;
            }
        }
    }
}

