/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.noise;

import cn.nukkit.level.generator.noise.Perlin;
import cn.nukkit.math.NukkitRandom;

public class Simplex
extends Perlin {
    protected static double SQRT_3;
    protected static double SQRT_5;
    protected static double F2;
    protected static double G2;
    protected static double G22;
    protected static double F3;
    protected static double G3;
    protected static double F4;
    protected static double G4;
    protected static double G42;
    protected static double G43;
    protected static double G44;
    protected static final int[][] grad4;
    protected static final int[][] simplex;
    protected final double offsetW;

    public Simplex(NukkitRandom random, double octaves, double persistence) {
        super(random, octaves, persistence);
        this.offsetW = random.nextDouble() * 256.0;
        SQRT_3 = Math.sqrt(3.0);
        SQRT_5 = Math.sqrt(5.0);
        F2 = 0.5 * (SQRT_3 - 1.0);
        G2 = (3.0 - SQRT_3) / 6.0;
        G22 = G2 * 2.0 - 1.0;
        F3 = 0.3333333333333333;
        G3 = 0.16666666666666666;
        F4 = (SQRT_5 - 1.0) / 4.0;
        G4 = (5.0 - SQRT_5) / 20.0;
        G42 = G4 * 2.0;
        G43 = G4 * 3.0;
        G44 = G4 * 4.0 - 1.0;
    }

    public Simplex(NukkitRandom random, double octaves, double persistence, double expansion) {
        super(random, octaves, persistence, expansion);
        this.offsetW = random.nextDouble() * 256.0;
        SQRT_3 = Math.sqrt(3.0);
        SQRT_5 = Math.sqrt(5.0);
        F2 = 0.5 * (SQRT_3 - 1.0);
        G2 = (3.0 - SQRT_3) / 6.0;
        G22 = G2 * 2.0 - 1.0;
        F3 = 0.3333333333333333;
        G3 = 0.16666666666666666;
        F4 = (SQRT_5 - 1.0) / 4.0;
        G4 = (5.0 - SQRT_5) / 20.0;
        G42 = G4 * 2.0;
        G43 = G4 * 3.0;
        G44 = G4 * 4.0 - 1.0;
    }

    protected static double dot2D(int[] g2, double x, double y) {
        return (double)g2[0] * x + (double)g2[1] * y;
    }

    protected static double dot3D(int[] g2, double x, double y, double z) {
        return (double)g2[0] * x + (double)g2[1] * y + (double)g2[2] * z;
    }

    protected static double dot4D(int[] g2, double x, double y, double z, double w) {
        return (double)g2[0] * x + (double)g2[1] * y + (double)g2[2] * z + (double)g2[3] * w;
    }

    @Override
    public double getNoise3D(double x, double y, double z) {
        double t3;
        double t2;
        double t1;
        double s2 = ((x += this.offsetX) + (y += this.offsetY) + (z += this.offsetZ)) * F3;
        int i = (int)(x + s2);
        int j = (int)(y + s2);
        int k = (int)(z + s2);
        double t4 = (double)(i + j + k) * G3;
        double x0 = x - ((double)i - t4);
        double y0 = y - ((double)j - t4);
        double z0 = z - ((double)k - t4);
        int i1 = 0;
        int j1 = 0;
        int k1 = 0;
        int i2 = 0;
        int j2 = 0;
        int k2 = 0;
        if (x0 >= y0) {
            if (y0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i2 = 1;
                j2 = 1;
                k2 = 0;
            } else if (x0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i2 = 1;
                j2 = 0;
                k2 = 1;
            } else {
                i1 = 0;
                j1 = 0;
                k1 = 1;
                i2 = 1;
                j2 = 0;
                k2 = 1;
            }
        } else if (y0 < z0) {
            i1 = 0;
            j1 = 0;
            k1 = 1;
            i2 = 0;
            j2 = 1;
            k2 = 1;
        } else if (x0 < z0) {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i2 = 0;
            j2 = 1;
            k2 = 1;
        } else {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i2 = 1;
            j2 = 1;
            k2 = 0;
        }
        double x1 = x0 - (double)i1 + G3;
        double y1 = y0 - (double)j1 + G3;
        double z1 = z0 - (double)k1 + G3;
        double x2 = x0 - (double)i2 + 2.0 * G3;
        double y2 = y0 - (double)j2 + 2.0 * G3;
        double z2 = z0 - (double)k2 + 2.0 * G3;
        double x3 = x0 - 1.0 + 3.0 * G3;
        double y3 = y0 - 1.0 + 3.0 * G3;
        double z3 = z0 - 1.0 + 3.0 * G3;
        int ii = i & 0xFF;
        int jj = j & 0xFF;
        int kk = k & 0xFF;
        double n = 0.0;
        double t0 = 0.6 - x0 * x0 - y0 * y0 - z0 * z0;
        if (t0 > 0.0) {
            int[] gi0 = grad3[this.perm[ii + this.perm[jj + this.perm[kk]]] % 12];
            n += t0 * t0 * t0 * t0 * ((double)gi0[0] * x0 + (double)gi0[1] * y0 + (double)gi0[2] * z0);
        }
        if ((t1 = 0.6 - x1 * x1 - y1 * y1 - z1 * z1) > 0.0) {
            int[] gi1 = grad3[this.perm[ii + i1 + this.perm[jj + j1 + this.perm[kk + k1]]] % 12];
            n += t1 * t1 * t1 * t1 * ((double)gi1[0] * x1 + (double)gi1[1] * y1 + (double)gi1[2] * z1);
        }
        if ((t2 = 0.6 - x2 * x2 - y2 * y2 - z2 * z2) > 0.0) {
            int[] gi2 = grad3[this.perm[ii + i2 + this.perm[jj + j2 + this.perm[kk + k2]]] % 12];
            n += t2 * t2 * t2 * t2 * ((double)gi2[0] * x2 + (double)gi2[1] * y2 + (double)gi2[2] * z2);
        }
        if ((t3 = 0.6 - x3 * x3 - y3 * y3 - z3 * z3) > 0.0) {
            int[] gi3 = grad3[this.perm[ii + 1 + this.perm[jj + 1 + this.perm[kk + 1]]] % 12];
            n += t3 * t3 * t3 * t3 * ((double)gi3[0] * x3 + (double)gi3[1] * y3 + (double)gi3[2] * z3);
        }
        return 32.0 * n;
    }

    @Override
    public double getNoise2D(double x, double y) {
        double t2;
        double t1;
        double s2 = ((x += this.offsetX) + (y += this.offsetY)) * F2;
        int i = (int)(x + s2);
        int j = (int)(y + s2);
        double t3 = (double)(i + j) * G2;
        double x0 = x - ((double)i - t3);
        double y0 = y - ((double)j - t3);
        int i1 = 0;
        int j1 = 0;
        if (x0 > y0) {
            i1 = 1;
            j1 = 0;
        } else {
            i1 = 0;
            j1 = 1;
        }
        double x1 = x0 - (double)i1 + G2;
        double y1 = y0 - (double)j1 + G2;
        double x2 = x0 + G22;
        double y2 = y0 + G22;
        int ii = i & 0xFF;
        int jj = j & 0xFF;
        double n = 0.0;
        double t0 = 0.5 - x0 * x0 - y0 * y0;
        if (t0 > 0.0) {
            int[] gi0 = grad3[this.perm[ii + this.perm[jj]] % 12];
            n += t0 * t0 * t0 * t0 * ((double)gi0[0] * x0 + (double)gi0[1] * y0);
        }
        if ((t1 = 0.5 - x1 * x1 - y1 * y1) > 0.0) {
            int[] gi1 = grad3[this.perm[ii + i1 + this.perm[jj + j1]] % 12];
            n += t1 * t1 * t1 * t1 * ((double)gi1[0] * x1 + (double)gi1[1] * y1);
        }
        if ((t2 = 0.5 - x2 * x2 - y2 * y2) > 0.0) {
            int[] gi2 = grad3[this.perm[ii + 1 + this.perm[jj + 1]] % 12];
            n += t2 * t2 * t2 * t2 * ((double)gi2[0] * x2 + (double)gi2[1] * y2);
        }
        return 70.0 * n;
    }

    static {
        grad4 = new int[][]{{0, 1, 1, 1}, {0, 1, 1, -1}, {0, 1, -1, 1}, {0, 1, -1, -1}, {0, -1, 1, 1}, {0, -1, 1, -1}, {0, -1, -1, 1}, {0, -1, -1, -1}, {1, 0, 1, 1}, {1, 0, 1, -1}, {1, 0, -1, 1}, {1, 0, -1, -1}, {-1, 0, 1, 1}, {-1, 0, 1, -1}, {-1, 0, -1, 1}, {-1, 0, -1, -1}, {1, 1, 0, 1}, {1, 1, 0, -1}, {1, -1, 0, 1}, {1, -1, 0, -1}, {-1, 1, 0, 1}, {-1, 1, 0, -1}, {-1, -1, 0, 1}, {-1, -1, 0, -1}, {1, 1, 1, 0}, {1, 1, -1, 0}, {1, -1, 1, 0}, {1, -1, -1, 0}, {-1, 1, 1, 0}, {-1, 1, -1, 0}, {-1, -1, 1, 0}, {-1, -1, -1, 0}};
        simplex = new int[][]{{0, 1, 2, 3}, {0, 1, 3, 2}, {0, 0, 0, 0}, {0, 2, 3, 1}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {1, 2, 3, 0}, {0, 2, 1, 3}, {0, 0, 0, 0}, {0, 3, 1, 2}, {0, 3, 2, 1}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {1, 3, 2, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {1, 2, 0, 3}, {0, 0, 0, 0}, {1, 3, 0, 2}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {2, 3, 0, 1}, {2, 3, 1, 0}, {1, 0, 2, 3}, {1, 0, 3, 2}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {2, 0, 3, 1}, {0, 0, 0, 0}, {2, 1, 3, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {2, 0, 1, 3}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {3, 0, 1, 2}, {3, 0, 2, 1}, {0, 0, 0, 0}, {3, 1, 2, 0}, {2, 1, 0, 3}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {3, 1, 0, 2}, {0, 0, 0, 0}, {3, 2, 0, 1}, {3, 2, 1, 0}};
    }
}

