/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator;

import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.Level;
import cn.nukkit.level.biome.EnumBiome;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.level.generator.Generator;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.Vector3;
import it.unimi.dsi.fastutil.longs.Long2LongLinkedOpenHashMap;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import net.daporkchop.lib.common.ref.Ref;
import net.daporkchop.lib.common.ref.ThreadRef;
import net.daporkchop.lib.common.util.PValidation;
import net.daporkchop.lib.noise.NoiseSource;
import net.daporkchop.lib.noise.engine.PerlinNoiseEngine;
import net.daporkchop.lib.noise.engine.SimplexNoiseEngine;
import net.daporkchop.lib.noise.filter.ScaleOctavesOffsetFilter;
import net.daporkchop.lib.random.PRandom;

public class TheEnd
extends Generator {
    private static final int STEP_X = 4;
    private static final int STEP_Y = 8;
    private static final int STEP_Z = 4;
    private static final int SAMPLES_X = 4;
    private static final int SAMPLES_Y = 32;
    private static final int SAMPLES_Z = 4;
    private static final int CACHE_X = 5;
    private static final int CACHE_Y = 33;
    private static final int CACHE_Z = 5;
    private static final double SCALE_X = 0.25;
    private static final double SCALE_Y = 0.125;
    private static final double SCALE_Z = 0.25;
    private static final double NOISE_SCALE_FACTOR = 127.998046875;
    private static final Ref<ThreadData> THREAD_DATA_CACHE = ThreadRef.soft(() -> new ThreadData());
    private static final double maxHeightCutoff = 56.0;
    private static final double minHeightCutoff = 32.0;
    private ChunkManager level;
    private ScaleOctavesOffsetFilter selector;
    private ScaleOctavesOffsetFilter low;
    private ScaleOctavesOffsetFilter high;
    private IslandCache islands;

    public TheEnd() {
    }

    public TheEnd(Map<String, Object> options) {
    }

    @Override
    public int getId() {
        return 4;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public ChunkManager getChunkManager() {
        return this.level;
    }

    @Override
    public Map<String, Object> getSettings() {
        return Collections.emptyMap();
    }

    @Override
    public String getName() {
        return "the_end";
    }

    @Override
    public void init(ChunkManager level, NukkitRandom random) {
        this.level = level;
        this.selector = new ScaleOctavesOffsetFilter(new PerlinNoiseEngine(PRandom.wrap(new Random(this.level.getSeed()))), 0.008354638671875, 0.008354638671875, 0.008354638671875, 8, 12.75, 0.5);
        this.low = new ScaleOctavesOffsetFilter(new PerlinNoiseEngine(PRandom.wrap(new Random(this.level.getSeed()))), 0.005221649169921875, 0.005221649169921875, 0.005221649169921875, 16, 1.0, 0.0);
        this.high = new ScaleOctavesOffsetFilter(new PerlinNoiseEngine(PRandom.wrap(new Random(this.level.getSeed()))), 0.005221649169921875, 0.005221649169921875, 0.005221649169921875, 16, 1.0, 0.0);
        this.islands = new IslandCache();
        this.islands.init(PRandom.wrap(new Random(this.level.getSeed())));
    }

    @Override
    public void generateChunk(int chunkX, int chunkZ) {
        int baseX = chunkX << 4;
        int baseZ = chunkZ << 4;
        BaseFullChunk chunk = this.level.getChunk(chunkX, chunkZ);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                chunk.setBiomeId(x, z, EnumBiome.END.biome.getId());
            }
        }
        ThreadData threadData = THREAD_DATA_CACHE.get();
        double[] densityCache = ThreadData.access$202(threadData, this.densityGet(threadData.densityCache, baseX, baseZ));
        int i = 0;
        for (int sectionX = 0; sectionX < 4; ++sectionX) {
            for (int sectionZ = 0; sectionZ < 4; ++sectionZ) {
                int sectionY = 0;
                while (sectionY < 32) {
                    double dxyz = densityCache[i];
                    double dxYz = densityCache[i + 1];
                    double dxyZ = densityCache[i + 33];
                    double dxYZ = densityCache[i + 33 + 1];
                    double dXyz = densityCache[i + 165];
                    double dXYz = densityCache[i + 165 + 1];
                    double dXyZ = densityCache[i + 165 + 33];
                    double dXYZ = densityCache[i + 165 + 33 + 1];
                    double bx00 = dxyz;
                    double bx01 = dxyZ;
                    double bx10 = dxYz;
                    double bx11 = dxYZ;
                    double gx00 = (dXyz - dxyz) * 0.25;
                    double gx01 = (dXyZ - dxyZ) * 0.25;
                    double gx10 = (dXYz - dxYz) * 0.25;
                    double gx11 = (dXYZ - dxYZ) * 0.25;
                    for (int stepX = 0; stepX < 4; ++stepX) {
                        double ix00 = bx00 + gx00 * (double)stepX;
                        double ix01 = bx01 + gx01 * (double)stepX;
                        double ix10 = bx10 + gx10 * (double)stepX;
                        double ix11 = bx11 + gx11 * (double)stepX;
                        double by0 = ix00;
                        double by1 = ix01;
                        double gy0 = (ix10 - ix00) * 0.125;
                        double gy1 = (ix11 - ix01) * 0.125;
                        for (int stepY = 0; stepY < 8; ++stepY) {
                            double iy0 = by0 + gy0 * (double)stepY;
                            double iy1 = by1 + gy1 * (double)stepY;
                            double bz = iy0;
                            double gz = (iy1 - iy0) * 0.25;
                            for (int stepZ = 0; stepZ < 4; ++stepZ) {
                                double iz = bz + gz * (double)stepZ;
                                int blockX = sectionX * 4 | stepX;
                                int blockY = sectionY * 8 | stepY;
                                int blockZ = sectionZ * 4 | stepZ;
                                if (!(iz > 0.0) || blockY <= 16) continue;
                                chunk.setBlockId(blockX, blockY, blockZ, 121);
                            }
                        }
                    }
                    ++sectionY;
                    ++i;
                }
                ++i;
            }
            i += 33;
        }
    }

    private double[] densityGet(double[] arr, int x, int z) {
        int totalSize = PValidation.positive(5) * PValidation.positive(33) * PValidation.positive(5) + PValidation.notNegative(0);
        if (arr == null || arr.length < totalSize) {
            arr = new double[totalSize];
        }
        int i = 0;
        int dx = 0;
        int xx = x;
        while (dx < 5) {
            int dz = 0;
            int zz = z;
            while (dz < 5) {
                double islandNoise = this.islands.get(xx, zz) - 8.0;
                int dy = 0;
                int yy = 0;
                while (dy < 33) {
                    double selector = NukkitMath.clamp(this.selector.get((double)xx, (double)yy, (double)zz), 0.0, 1.0);
                    double low = this.low.get((double)xx, (double)yy, (double)zz) * 127.998046875;
                    double high = this.high.get((double)xx, (double)yy, (double)zz) * 127.998046875;
                    arr[i++] = this.cutOff(yy, NukkitMath.lerp(low, high, selector) + islandNoise);
                    ++dy;
                    yy += 8;
                }
                ++dz;
                zz += 4;
            }
            ++dx;
            xx += 4;
        }
        return arr;
    }

    private double cutOff(double y, double noise) {
        if (y > 56.0) {
            double factor = NukkitMath.clamp((y * 0.125 - 4.0) * 0.015625, 0.0, 1.0);
            return noise * (1.0 - factor) - 3000.0 * factor;
        }
        if (y < 32.0) {
            if (y < 16.0) {
                return 0.0;
            }
            double factor = (4.0 - y * 0.125) / 3.0;
            return noise * (1.0 - factor) - 30.0 * factor;
        }
        return noise;
    }

    @Override
    public void populateChunk(int chunkX, int chunkZ) {
    }

    @Override
    public Vector3 getSpawn() {
        return new Vector3(100.5, 49.0, 0.5);
    }

    private static class IslandCache {
        private static final long NaN = Double.doubleToRawLongBits(Double.NaN);
        private final Ref<Long2LongLinkedOpenHashMap> cacheCache = ThreadRef.soft(Long2LongLinkedOpenHashMap::new);
        private NoiseSource island;
        private NoiseSource weight;

        private IslandCache() {
        }

        private double get(int x, int z) {
            Long2LongLinkedOpenHashMap cache = this.cacheCache.get();
            long val = cache.getOrDefault(Level.chunkHash(x, z), NaN);
            if (val == NaN) {
                if (cache.size() >= 1024) {
                    cache.removeFirstLong();
                }
                val = Double.doubleToRawLongBits(this.computeValue(x, z));
                cache.put(Level.chunkHash(x, z), val);
            }
            return Double.longBitsToDouble(val);
        }

        private void init(PRandom random) {
            this.island = new ScaleOctavesOffsetFilter(new SimplexNoiseEngine(PRandom.wrap(new Random(random.nextLong()))), 1.0, 1.0, 1.0, 1, 1.0, 0.0);
            this.weight = new ScaleOctavesOffsetFilter(new SimplexNoiseEngine(PRandom.wrap(new Random(random.nextLong()))), 1.0, 1.0, 1.0, 1, 6.5, 15.5);
        }

        private double computeValue(int x, int z) {
            double islandRadius = 100.0;
            double outerIslandStartRadiusSq = 4096.0;
            double outerIslandSeedThreshold = -0.8;
            double chunkX = x >> 4;
            double chunkZ = z >> 4;
            double tileX = (double)(x & 0xF) * 0.125;
            double tileZ = (double)(z & 0xF) * 0.125;
            double val = 100.0 - Math.sqrt((double)x * 0.125 * ((double)x * 0.125) + (double)z * 0.125 * ((double)z * 0.125)) * 8.0;
            for (int dx = -12; dx <= 12; ++dx) {
                for (int dz = -12; dz <= 12; ++dz) {
                    double islandX = chunkX + (double)dx;
                    double islandZ = chunkZ + (double)dz;
                    if (!(islandX * islandX + islandZ * islandZ > 4096.0) || !(this.island.get(islandX, islandZ) < -0.8)) continue;
                    double weight = this.weight.get(islandX, islandZ);
                    double offsetX = tileX - (double)dx * 2.0;
                    double offsetZ = tileZ - (double)dz * 2.0;
                    val = Math.max(val, 100.0 - Math.sqrt(offsetX * offsetX + offsetZ * offsetZ) * weight);
                }
            }
            return NukkitMath.clamp(val, -100.0, 80.0);
        }
    }

    private static final class ThreadData {
        private double[] densityCache;

        private ThreadData() {
        }

        static /* synthetic */ double[] access$202(ThreadData x0, double[] x1) {
            x0.densityCache = x1;
            return x1;
        }
    }
}

