/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator;

import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.level.generator.SimpleChunkManager;

public class SingleChunkManager
extends SimpleChunkManager {
    private int CX = Integer.MAX_VALUE;
    private int CZ = Integer.MAX_VALUE;
    private BaseFullChunk chunk;

    public SingleChunkManager(long seed) {
        super(seed);
    }

    @Override
    public BaseFullChunk getChunk(int chunkX, int chunkZ) {
        if (chunkX == this.CX && chunkZ == this.CZ) {
            return this.chunk;
        }
        return null;
    }

    @Override
    public void setChunk(int chunkX, int chunkZ, BaseFullChunk chunk) {
        if (chunk == null) {
            this.chunk = null;
            this.CX = Integer.MAX_VALUE;
            this.CZ = Integer.MAX_VALUE;
        } else {
            if (this.chunk != null) {
                throw new UnsupportedOperationException("Replacing chunks is not allowed behavior");
            }
            this.chunk = chunk;
            this.CX = chunk.getX();
            this.CZ = chunk.getZ();
        }
    }

    @Override
    public void cleanChunks(long seed) {
        super.cleanChunks(seed);
        this.chunk = null;
        this.CX = Integer.MAX_VALUE;
        this.CZ = Integer.MAX_VALUE;
    }

    @Override
    public int getMinBlockY() {
        return 0;
    }

    @Override
    public int getMaxBlockY() {
        return 255;
    }
}

