/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator;

import cn.nukkit.block.Block;
import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.biome.Biome;
import cn.nukkit.level.biome.EnumBiome;
import cn.nukkit.level.biome.type.CoveredBiome;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.level.format.leveldb.structure.LevelDBChunk;
import cn.nukkit.level.generator.Generator;
import cn.nukkit.level.generator.noise.nukkit.f.SimplexF;
import cn.nukkit.level.generator.object.ore.OreType;
import cn.nukkit.level.generator.populator.impl.PopulatorBedrock;
import cn.nukkit.level.generator.populator.impl.PopulatorGlowStone;
import cn.nukkit.level.generator.populator.impl.PopulatorLava;
import cn.nukkit.level.generator.populator.impl.PopulatorNetherFire;
import cn.nukkit.level.generator.populator.impl.PopulatorOre;
import cn.nukkit.level.generator.populator.type.Populator;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.Vector3;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.daporkchop.lib.common.ref.Ref;
import net.daporkchop.lib.common.ref.ThreadRef;
import net.daporkchop.lib.common.util.PValidation;
import net.daporkchop.lib.noise.engine.PerlinNoiseEngine;
import net.daporkchop.lib.noise.filter.ScaleOctavesOffsetFilter;
import net.daporkchop.lib.random.PRandom;

public class Nether
extends Generator {
    private final boolean legacy;
    private final int version;
    private ChunkManager level;
    private NukkitRandom nukkitRandom;
    private static final int lavaHeight = 32;
    private final SimplexF[] noiseGen = new SimplexF[3];
    private final List<Populator> populators = new ArrayList<Populator>();
    private final List<Populator> generationPopulators = new ArrayList<Populator>();
    private long localSeed1;
    private long localSeed2;
    private SimplexF biomeNoise;
    private static final int STEP_X = 4;
    private static final int STEP_Y = 8;
    private static final int STEP_Z = 4;
    private static final int SAMPLES_X = 4;
    private static final int SAMPLES_Y = 32;
    private static final int SAMPLES_Z = 4;
    private static final int CACHE_X = 5;
    private static final int CACHE_Y = 33;
    private static final int CACHE_Z = 5;
    private static final double SCALE_X = 0.25;
    private static final double SCALE_Y = 0.125;
    private static final double SCALE_Z = 0.25;
    private static final double NOISE_SCALE_FACTOR = 127.998046875;
    private static final Ref<ThreadData> THREAD_DATA_CACHE = ThreadRef.soft(() -> new ThreadData());
    private ScaleOctavesOffsetFilter selector;
    private ScaleOctavesOffsetFilter low;
    private ScaleOctavesOffsetFilter high;

    public Nether() {
        this(Collections.emptyMap());
    }

    public Nether(Map<String, Object> options) {
        this.legacy = !options.containsKey("__LevelDB");
        this.version = (Integer)options.getOrDefault("__Version", 0);
    }

    @Override
    public int getId() {
        return 3;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public String getName() {
        return "nether";
    }

    @Override
    public Map<String, Object> getSettings() {
        return Collections.emptyMap();
    }

    @Override
    public ChunkManager getChunkManager() {
        return this.level;
    }

    @Override
    public void init(ChunkManager level, NukkitRandom random) {
        this.level = level;
        this.nukkitRandom = random;
        this.nukkitRandom.setSeed(this.level.getSeed());
        if (this.legacy || this.version < 2) {
            for (int i = 0; i < this.noiseGen.length; ++i) {
                this.noiseGen[i] = new SimplexF(this.nukkitRandom, 4.0f, 0.25f, 0.015625f);
            }
        } else {
            this.selector = new ScaleOctavesOffsetFilter(new PerlinNoiseEngine(PRandom.wrap(new Random(this.level.getSeed()))), 0.01670927734375, 0.0334185546875, 0.01670927734375, 8, 12.75, 0.5);
            this.low = new ScaleOctavesOffsetFilter(new PerlinNoiseEngine(PRandom.wrap(new Random(this.level.getSeed()))), 0.005221649169921875, 0.007832473754882812, 0.005221649169921875, 16, 1.0, 0.0);
            this.high = new ScaleOctavesOffsetFilter(new PerlinNoiseEngine(PRandom.wrap(new Random(this.level.getSeed()))), 0.005221649169921875, 0.007832473754882812, 0.005221649169921875, 16, 1.0, 0.0);
        }
        this.nukkitRandom.setSeed(this.level.getSeed());
        this.localSeed1 = ThreadLocalRandom.current().nextLong();
        this.localSeed2 = ThreadLocalRandom.current().nextLong();
        this.biomeNoise = new SimplexF(this.nukkitRandom, 2.0f, 0.125f, 4.8828125E-4f);
        PopulatorBedrock bedrock = new PopulatorBedrock(true);
        this.generationPopulators.add(bedrock);
        PopulatorOre ores = this.legacy ? new PopulatorOre(87, new OreType[]{new OreType(Block.get(153), 16, 24, 10, 117, 87), new OreType(Block.get(88), 12, 23, 0, 105, 87), new OreType(Block.get(13), 2, 64, 5, 105, 87), new OreType(Block.get(213), 4, 64, 26, 33, 87), new OreType(Block.get(10), 1, 16, 0, 32, 87)}) : new PopulatorOre(87, new OreType[]{new OreType(Block.get(153), 16, 24, 10, 117, 87), new OreType(Block.get(88), 12, 23, 0, 105, 87), new OreType(Block.get(13), 2, 64, 5, 105, 87), new OreType(Block.get(213), 4, 64, 26, 33, 87), new OreType(Block.get(10), 1, 16, 0, 32, 87), new OreType(Block.get(543), 10, 16, 10, 117, 87), new OreType(Block.get(526), 2, 3, 8, 23, 87), new OreType(Block.get(526), 3, 2, 8, 119, 87)});
        this.populators.add(ores);
        this.populators.add(new PopulatorNetherFire(51, 87));
        PopulatorLava lava = new PopulatorLava();
        lava.setRandomAmount(2);
        this.populators.add(lava);
        this.populators.add(new PopulatorGlowStone());
    }

    @Override
    public void generateChunk(int chunkX, int chunkZ) {
        int baseX = chunkX << 4;
        int baseZ = chunkZ << 4;
        this.nukkitRandom.setSeed((long)chunkX * this.localSeed1 ^ (long)chunkZ * this.localSeed2 ^ this.level.getSeed());
        BaseFullChunk chunk = this.level.getChunk(chunkX, chunkZ);
        if (this.version < 2 || !(chunk instanceof LevelDBChunk)) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int y;
                    chunk.setBiomeId(x, z, EnumBiome.HELL.biome.getId());
                    for (y = 115; y < 127; ++y) {
                        chunk.setBlockId(x, y, z, 87);
                    }
                    for (y = 1; y < 127; ++y) {
                        if (this.getNoise(baseX | x, y, baseZ | z) > 0.0f) {
                            chunk.setBlockId(x, y, z, 87);
                            continue;
                        }
                        if (y > 32) continue;
                        chunk.setBlockId(x, y, z, 11);
                        chunk.setBlockLight(x, y + 1, z, 15);
                    }
                }
            }
        } else {
            CoveredBiome[][] biomes = new CoveredBiome[16][16];
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    CoveredBiome biome = (CoveredBiome)this.pickBiome(baseX + x, baseZ + z);
                    chunk.setBiomeId(x, z, biome.getId());
                    biomes[x][z] = biome;
                }
            }
            ThreadData threadData = THREAD_DATA_CACHE.get();
            double[] densityCache = ThreadData.access$002(threadData, this.densityGet(threadData.densityCache, baseX, 0, baseZ));
            int i = 0;
            for (int sectionX = 0; sectionX < 4; ++sectionX) {
                for (int sectionZ = 0; sectionZ < 4; ++sectionZ) {
                    int sectionY = 0;
                    while (sectionY < 32) {
                        double dxyz = densityCache[i];
                        double dxYz = densityCache[i + 1];
                        double dxyZ = densityCache[i + 33];
                        double dxYZ = densityCache[i + 33 + 1];
                        double dXyz = densityCache[i + 165];
                        double dXYz = densityCache[i + 165 + 1];
                        double dXyZ = densityCache[i + 165 + 33];
                        double dXYZ = densityCache[i + 165 + 33 + 1];
                        double bx00 = dxyz;
                        double bx01 = dxyZ;
                        double bx10 = dxYz;
                        double bx11 = dxYZ;
                        double gx00 = (dXyz - dxyz) * 0.25;
                        double gx01 = (dXyZ - dxyZ) * 0.25;
                        double gx10 = (dXYz - dxYz) * 0.25;
                        double gx11 = (dXYZ - dxYZ) * 0.25;
                        for (int stepX = 0; stepX < 4; ++stepX) {
                            double ix00 = bx00 + gx00 * (double)stepX;
                            double ix01 = bx01 + gx01 * (double)stepX;
                            double ix10 = bx10 + gx10 * (double)stepX;
                            double ix11 = bx11 + gx11 * (double)stepX;
                            double by0 = ix00;
                            double by1 = ix01;
                            double gy0 = (ix10 - ix00) * 0.125;
                            double gy1 = (ix11 - ix01) * 0.125;
                            for (int stepY = 0; stepY < 8; ++stepY) {
                                double iy0 = by0 + gy0 * (double)stepY;
                                double iy1 = by1 + gy1 * (double)stepY;
                                double bz = iy0;
                                double gz = (iy1 - iy0) * 0.25;
                                for (int stepZ = 0; stepZ < 4; ++stepZ) {
                                    double iz = bz + gz * (double)stepZ;
                                    int blockX = sectionX * 4 | stepX;
                                    int blockY = sectionY * 8 | stepY;
                                    int blockZ = sectionZ * 4 | stepZ;
                                    if (blockY < 127 && iz > 0.0) {
                                        CoveredBiome biome = biomes[blockX][blockZ];
                                        chunk.setFullBlockId(blockX, blockY, blockZ, biome.getGroundId(blockX, 0, blockZ));
                                        continue;
                                    }
                                    if (blockY > 32) continue;
                                    chunk.setBlockId(blockX, blockY, blockZ, 11);
                                    chunk.setBlockLight(blockX, blockY + 1, blockZ, 15);
                                }
                            }
                        }
                        ++sectionY;
                        ++i;
                    }
                    ++i;
                }
                i += 33;
            }
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int surface;
                    CoveredBiome biome = biomes[x][z];
                    int ground = biome.getGroundId(x, 0, z);
                    if (ground == (surface = biome.getSurfaceId(x, 0, z))) continue;
                    int previous = chunk.getBlockId(x, 126, z);
                    for (int y = 125; y > 1; --y) {
                        int id = chunk.getFullBlock(x, y, z);
                        if (id == ground && previous == 0) {
                            chunk.setFullBlockId(x, y, z, surface);
                        }
                        previous = id;
                    }
                }
            }
        }
        for (Populator populator : this.generationPopulators) {
            populator.populate(this.level, chunkX, chunkZ, this.nukkitRandom, chunk);
        }
    }

    private double densityGet(int x, int y, int z) {
        if (y >= 128) {
            return 0.0;
        }
        double selector = NukkitMath.clamp(this.selector.get((double)x, (double)y, (double)z), 0.0, 1.0);
        double low = this.low.get((double)x, (double)y, (double)z) * 127.998046875;
        double high = this.high.get((double)x, (double)y, (double)z) * 127.998046875;
        double outputNoise = NukkitMath.lerp(low, high, selector);
        double threshold = (double)y * 0.125;
        double offset = Math.cos(threshold * Math.PI * 6.0 / 17.0) * 2.0;
        if (threshold > 8.0) {
            threshold = 16.0 - threshold;
        }
        if (threshold < 4.0) {
            threshold = 4.0 - threshold;
            offset -= threshold * threshold * threshold * 10.0;
        }
        return outputNoise - offset;
    }

    private double[] densityGet(double[] arr, int x, int y, int z) {
        int totalSize = PValidation.positive(5) * PValidation.positive(33) * PValidation.positive(5) + PValidation.notNegative(0);
        if (arr == null || arr.length < totalSize) {
            arr = new double[totalSize];
        }
        int i = 0;
        for (int dx = 0; dx < 5; ++dx) {
            for (int dz = 0; dz < 5; ++dz) {
                for (int dy = 0; dy < 33; ++dy) {
                    arr[i++] = this.densityGet(x + dx * 4, y + dy * 8, z + dz * 4);
                }
            }
        }
        return arr;
    }

    private Biome pickBiome(int x, int z) {
        float value = this.biomeNoise.noise2D(x, z, true);
        float secondaryValue = this.biomeNoise.noise2D(z, x, true);
        if (value >= 0.33333334f) {
            return secondaryValue >= 0.0f ? EnumBiome.WARPED_FOREST.biome : EnumBiome.CRIMSON_FOREST.biome;
        }
        if (value >= -0.33333334f) {
            return EnumBiome.HELL.biome;
        }
        return secondaryValue >= 0.0f ? EnumBiome.BASALT_DELTAS.biome : EnumBiome.SOULSAND_VALLEY.biome;
    }

    @Override
    public void populateChunk(int chunkX, int chunkZ) {
        BaseFullChunk chunk = this.level.getChunk(chunkX, chunkZ);
        this.nukkitRandom.setSeed((long)(0xDEADBEEF ^ chunkX << 8 ^ chunkZ) ^ this.level.getSeed());
        for (Populator populator : this.populators) {
            populator.populate(this.level, chunkX, chunkZ, this.nukkitRandom, chunk);
        }
        if (!(chunk instanceof LevelDBChunk)) {
            EnumBiome.HELL.biome.populateChunk(this.level, chunkX, chunkZ, this.nukkitRandom);
        } else {
            Biome biome = Biome.getBiome(chunk.getBiomeId(7, 7));
            biome.populateChunk(this.level, chunkX, chunkZ, this.nukkitRandom);
        }
    }

    @Override
    public Vector3 getSpawn() {
        return new Vector3(0.5, 64.0, 0.5);
    }

    public float getNoise(int x, int y, int z) {
        float val = 0.0f;
        for (int i = 0; i < this.noiseGen.length; ++i) {
            val += this.noiseGen[i].noise3D(x >> i, y, z >> i, true);
        }
        return val;
    }

    private static final class ThreadData {
        private double[] densityCache;

        private ThreadData() {
        }

        static /* synthetic */ double[] access$002(ThreadData x0, double[] x1) {
            x0.densityCache = x1;
            return x1;
        }
    }
}

