/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.leveldb.structure;

import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockLayer;
import cn.nukkit.level.format.ChunkSection;
import cn.nukkit.level.format.generic.EmptyChunkSection;
import cn.nukkit.level.format.leveldb.structure.StateBlockStorage;
import cn.nukkit.utils.Binary;
import cn.nukkit.utils.BinaryStream;
import cn.nukkit.utils.Utils;
import cn.nukkit.utils.Zlib;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;

public class LevelDBChunkSection
implements ChunkSection {
    private final int y;
    private final StateBlockStorage[] storages;
    protected byte[] blockLight;
    protected byte[] skyLight;
    private byte[] compressedLight;
    protected boolean hasBlockLight;
    protected boolean hasSkyLight;

    public LevelDBChunkSection(int y, StateBlockStorage[] storages, byte[] blockLight, byte[] skyLight, byte[] compressedLight, boolean hasBlockLight, boolean hasSkyLight) {
        this.y = y;
        this.storages = storages;
        this.blockLight = blockLight;
        this.skyLight = skyLight;
        this.compressedLight = compressedLight;
        this.hasBlockLight = hasBlockLight;
        this.hasSkyLight = hasSkyLight;
    }

    public LevelDBChunkSection(int y) {
        this(y, new StateBlockStorage[]{new StateBlockStorage(), new StateBlockStorage()}, null, null, null, false, true);
    }

    private StateBlockStorage computeStorage(BlockLayer layer) {
        if (this.storages.length <= layer.ordinal()) {
            throw new IllegalArgumentException("Tried to get layer " + (Object)((Object)layer) + " but LevelDBChunkSection has only " + this.storages.length);
        }
        StateBlockStorage storage = this.storages[layer.ordinal()];
        if (storage == null) {
            StateBlockStorage stateBlockStorage = new StateBlockStorage();
            this.storages[layer.ordinal()] = stateBlockStorage;
            return stateBlockStorage;
        }
        return storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBlockId(int x, int y, int z, BlockLayer layer) {
        StateBlockStorage[] stateBlockStorageArray = this.storages;
        synchronized (this.storages) {
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return this.computeStorage(layer).getBlockId(x, y, z);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlockId(int x, int y, int z, BlockLayer layer, int id) {
        StateBlockStorage[] stateBlockStorageArray = this.storages;
        synchronized (this.storages) {
            this.computeStorage(layer).setBlockId(x, y, z, id);
            if (layer != Block.LAYER_WATERLOGGED && id == 0 && this.hasSecondLayer()) {
                this.computeStorage(Block.LAYER_WATERLOGGED).setBlockId(x, y, z, 0);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setFullBlockId(int x, int y, int z, BlockLayer layer, int fullId) {
        StateBlockStorage[] stateBlockStorageArray = this.storages;
        synchronized (this.storages) {
            this.computeStorage(layer).setFullBlock(x, y, z, fullId);
            if (layer != Block.LAYER_WATERLOGGED && fullId == 0 && this.hasSecondLayer()) {
                this.computeStorage(Block.LAYER_WATERLOGGED).setFullBlock(x, y, z, 0);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBlockData(int x, int y, int z, BlockLayer layer) {
        StateBlockStorage[] stateBlockStorageArray = this.storages;
        synchronized (this.storages) {
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return this.computeStorage(layer).getBlockData(x, y, z);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlockData(int x, int y, int z, BlockLayer layer, int data) {
        StateBlockStorage[] stateBlockStorageArray = this.storages;
        synchronized (this.storages) {
            this.computeStorage(layer).setBlockData(x, y, z, data);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFullBlock(int x, int y, int z, BlockLayer layer) {
        StateBlockStorage[] stateBlockStorageArray = this.storages;
        synchronized (this.storages) {
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return this.computeStorage(layer).getFullBlock(x, y, z);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block getAndSetBlock(int x, int y, int z, BlockLayer layer, Block block) {
        StateBlockStorage[] stateBlockStorageArray = this.storages;
        synchronized (this.storages) {
            int fullId = this.computeStorage(layer).getAndSetFullBlock(x, y, z, block.getFullId());
            if (layer != Block.LAYER_WATERLOGGED && block.getId() == 0 && fullId != block.getFullId() && this.hasSecondLayer()) {
                this.computeStorage(Block.LAYER_WATERLOGGED).setFullBlock(x, y, z, 0);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return Block.get(fullId, null, x, y, z, layer);
        }
    }

    @Override
    public boolean setBlock(int x, int y, int z, int blockId) {
        return this.setBlock(x, y, z, blockId, 0);
    }

    @Override
    public boolean setBlock(int x, int y, int z, int blockId, int meta) {
        return this.setBlockAtLayer(x, y, z, Block.LAYER_NORMAL, blockId, meta);
    }

    @Override
    public boolean setBlockAtLayer(int x, int y, int z, BlockLayer layer, int blockId) {
        return this.setBlockAtLayer(x, y, z, layer, blockId, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setBlockAtLayer(int x, int y, int z, BlockLayer layer, int blockId, int meta) {
        StateBlockStorage[] stateBlockStorageArray = this.storages;
        synchronized (this.storages) {
            boolean success;
            int fullId = blockId << 6 | meta;
            boolean bl = success = this.computeStorage(layer).getAndSetFullBlock(x, y, z, fullId) != fullId;
            if (layer != Block.LAYER_WATERLOGGED && blockId == 0 && this.hasSecondLayer()) {
                this.computeStorage(Block.LAYER_WATERLOGGED).setFullBlock(x, y, z, 0);
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return success;
        }
    }

    @Override
    public int getBlockSkyLight(int x, int y, int z) {
        if (this.skyLight == null) {
            if (!this.hasSkyLight) {
                return 0;
            }
            if (this.compressedLight == null) {
                return 15;
            }
        }
        this.skyLight = this.getSkyLightArray();
        int sl = this.skyLight[y << 7 | z << 3 | x >> 1] & 0xFF;
        if ((x & 1) == 0) {
            return sl & 0xF;
        }
        return sl >> 4;
    }

    @Override
    public void setBlockSkyLight(int x, int y, int z, int level) {
        if (this.skyLight == null) {
            if (this.hasSkyLight && this.compressedLight != null) {
                this.skyLight = this.getSkyLightArray();
            } else {
                if (level == (this.hasSkyLight ? 15 : 0)) {
                    return;
                }
                this.skyLight = new byte[2048];
                if (this.hasSkyLight) {
                    Arrays.fill(this.skyLight, (byte)-1);
                }
            }
        }
        int i = y << 7 | z << 3 | x >> 1;
        int old = this.skyLight[i] & 0xFF;
        this.skyLight[i] = (x & 1) == 0 ? (byte)(old & 0xF0 | level & 0xF) : (byte)((level & 0xF) << 4 | old & 0xF);
    }

    @Override
    public int getBlockLight(int x, int y, int z) {
        if (this.blockLight == null && !this.hasBlockLight) {
            return 0;
        }
        this.blockLight = this.getLightArray();
        int l = this.blockLight[y << 7 | z << 3 | x >> 1] & 0xFF;
        if ((x & 1) == 0) {
            return l & 0xF;
        }
        return l >> 4;
    }

    @Override
    public void setBlockLight(int x, int y, int z, int level) {
        if (this.blockLight == null) {
            if (this.hasBlockLight) {
                this.blockLight = this.getLightArray();
            } else {
                if (level == 0) {
                    return;
                }
                this.blockLight = new byte[2048];
            }
        }
        int i = y << 7 | z << 3 | x >> 1;
        int old = this.blockLight[i] & 0xFF;
        this.blockLight[i] = (x & 1) == 0 ? (byte)(old & 0xF0 | level & 0xF) : (byte)((level & 0xF) << 4 | old & 0xF);
    }

    @Override
    public byte[] getIdArray() {
        return new byte[0];
    }

    @Override
    public byte[] getDataArray() {
        return new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(BinaryStream stream) {
        StateBlockStorage[] stateBlockStorageArray = this.storages;
        synchronized (this.storages) {
            boolean waterLogging = this.hasSecondLayer();
            stream.putByte((byte)8);
            stream.putByte((byte)(waterLogging ? 2 : 1));
            this.storages[0].writeTo(stream);
            if (waterLogging) {
                this.storages[1].writeTo(stream);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private boolean hasSecondLayer() {
        return this.storages.length > 1 && this.storages[1] != null;
    }

    @Override
    public byte[] getSkyLightArray() {
        if (this.skyLight != null) {
            return this.skyLight;
        }
        if (this.hasSkyLight && this.compressedLight != null) {
            this.inflate();
            if (this.skyLight != null) {
                return this.skyLight;
            }
        }
        return EmptyChunkSection.EMPTY_SKY_LIGHT_ARR;
    }

    private void inflate() {
        try {
            if (this.compressedLight != null && this.compressedLight.length != 0) {
                byte[] inflated = Zlib.inflate(this.compressedLight);
                this.blockLight = Arrays.copyOfRange(inflated, 0, 2048);
                if (inflated.length > 2048) {
                    this.skyLight = Arrays.copyOfRange(inflated, 2048, 4096);
                } else {
                    this.skyLight = new byte[2048];
                    if (this.hasSkyLight) {
                        Arrays.fill(this.skyLight, (byte)-1);
                    }
                }
                this.compressedLight = null;
            } else {
                if (this.blockLight == null) {
                    this.blockLight = new byte[2048];
                }
                this.skyLight = new byte[2048];
                if (this.hasSkyLight) {
                    Arrays.fill(this.skyLight, (byte)-1);
                }
            }
        }
        catch (IOException e) {
            Server.getInstance().getLogger().logException(e);
        }
    }

    @Override
    public byte[] getLightArray() {
        if (this.blockLight != null) {
            return this.blockLight;
        }
        if (this.hasBlockLight) {
            this.inflate();
            if (this.blockLight != null) {
                return this.blockLight;
            }
        }
        return EmptyChunkSection.EMPTY_LIGHT_ARR;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public ChunkSection copy() {
        StateBlockStorage[] storages = new StateBlockStorage[this.storages.length];
        for (int i = 0; i < this.storages.length; ++i) {
            if (this.storages[i] == null) continue;
            storages[i] = this.storages[i].copy();
        }
        return new LevelDBChunkSection(this.y, storages, this.blockLight == null ? null : (byte[])this.blockLight.clone(), this.skyLight == null ? null : (byte[])this.skyLight.clone(), this.compressedLight == null ? null : (byte[])this.compressedLight.clone(), this.hasBlockLight, this.hasSkyLight);
    }

    @Override
    public ChunkSection copyForChunkSending() {
        StateBlockStorage[] storages = new StateBlockStorage[this.storages.length];
        for (int i = 0; i < this.storages.length; ++i) {
            if (this.storages[i] == null) continue;
            storages[i] = this.storages[i].copy();
        }
        return new LevelDBChunkSection(this.y, storages, null, null, null, false, false);
    }

    public boolean compress() {
        if (this.blockLight != null) {
            byte[] arr2;
            byte[] arr1 = this.blockLight;
            boolean bl = this.hasBlockLight = !Utils.isByteArrayEmpty(arr1);
            if (this.skyLight != null) {
                arr2 = this.skyLight;
                this.hasSkyLight = !Utils.isByteArrayEmpty(arr2);
            } else if (this.hasSkyLight) {
                arr2 = EmptyChunkSection.EMPTY_SKY_LIGHT_ARR;
            } else {
                arr2 = EmptyChunkSection.EMPTY_LIGHT_ARR;
                this.hasSkyLight = false;
            }
            this.blockLight = null;
            this.skyLight = null;
            byte[] toDeflate = null;
            if (this.hasBlockLight && this.hasSkyLight && arr2 != EmptyChunkSection.EMPTY_SKY_LIGHT_ARR) {
                toDeflate = Binary.appendBytes(arr1, (byte[][])new byte[][]{arr2});
            } else if (this.hasBlockLight) {
                toDeflate = arr1;
            }
            if (toDeflate != null) {
                try {
                    this.compressedLight = Zlib.deflate(toDeflate, 1);
                }
                catch (Exception e) {
                    Server.getInstance().getLogger().logException(e);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    @Generated
    public int getY() {
        return this.y;
    }

    @Generated
    public StateBlockStorage[] getStorages() {
        return this.storages;
    }
}

