/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.leveldb.structure;

import cn.nukkit.level.GlobalBlockPalette;
import cn.nukkit.level.format.leveldb.BlockStateMapping;
import lombok.Generated;
import org.cloudburstmc.nbt.NbtMap;

public class BlockStateSnapshot {
    private final NbtMap vanillaState;
    private final int runtimeId;
    private final int version;
    private boolean custom;
    private int legacyId;
    private int legacyData;
    private int runtimeIdNetworkProtocol;

    public int getLegacyId() {
        if (this.legacyId != -1) {
            return this.legacyId;
        }
        int id = BlockStateMapping.get().getLegacyId(this.runtimeId);
        if (this.version == BlockStateMapping.get().getVersion()) {
            this.legacyId = id;
        }
        return id;
    }

    public int getLegacyData() {
        if (this.legacyData != -1) {
            return this.legacyData;
        }
        int data = BlockStateMapping.get().getLegacyData(this.runtimeId);
        if (this.version == BlockStateMapping.get().getVersion()) {
            this.legacyData = data;
        }
        return data;
    }

    int getRuntimeIdNetworkProtocol() {
        if (this.runtimeIdNetworkProtocol == -1) {
            this.runtimeIdNetworkProtocol = GlobalBlockPalette.getOrCreateRuntimeId(this.getLegacyId(), this.getLegacyData());
        }
        return this.runtimeIdNetworkProtocol;
    }

    @Generated
    private static boolean $default$custom() {
        return false;
    }

    @Generated
    private static int $default$legacyId() {
        return -1;
    }

    @Generated
    private static int $default$legacyData() {
        return -1;
    }

    @Generated
    private static int $default$runtimeIdNetworkProtocol() {
        return -1;
    }

    @Generated
    BlockStateSnapshot(NbtMap vanillaState, int runtimeId, int version, boolean custom, int legacyId, int legacyData, int runtimeIdNetworkProtocol) {
        this.vanillaState = vanillaState;
        this.runtimeId = runtimeId;
        this.version = version;
        this.custom = custom;
        this.legacyId = legacyId;
        this.legacyData = legacyData;
        this.runtimeIdNetworkProtocol = runtimeIdNetworkProtocol;
    }

    @Generated
    public static BlockStateSnapshotBuilder builder() {
        return new BlockStateSnapshotBuilder();
    }

    @Generated
    public NbtMap getVanillaState() {
        return this.vanillaState;
    }

    @Generated
    public int getRuntimeId() {
        return this.runtimeId;
    }

    @Generated
    public int getVersion() {
        return this.version;
    }

    @Generated
    public boolean isCustom() {
        return this.custom;
    }

    @Generated
    public String toString() {
        return "BlockStateSnapshot(vanillaState=" + this.getVanillaState() + ", runtimeId=" + this.getRuntimeId() + ", version=" + this.getVersion() + ", custom=" + this.isCustom() + ", legacyId=" + this.getLegacyId() + ", legacyData=" + this.getLegacyData() + ", runtimeIdNetworkProtocol=" + this.getRuntimeIdNetworkProtocol() + ")";
    }

    @Generated
    public static class BlockStateSnapshotBuilder {
        @Generated
        private NbtMap vanillaState;
        @Generated
        private int runtimeId;
        @Generated
        private int version;
        @Generated
        private boolean custom$set;
        @Generated
        private boolean custom$value;
        @Generated
        private boolean legacyId$set;
        @Generated
        private int legacyId$value;
        @Generated
        private boolean legacyData$set;
        @Generated
        private int legacyData$value;
        @Generated
        private boolean runtimeIdNetworkProtocol$set;
        @Generated
        private int runtimeIdNetworkProtocol$value;

        @Generated
        BlockStateSnapshotBuilder() {
        }

        @Generated
        public BlockStateSnapshotBuilder vanillaState(NbtMap vanillaState) {
            this.vanillaState = vanillaState;
            return this;
        }

        @Generated
        public BlockStateSnapshotBuilder runtimeId(int runtimeId) {
            this.runtimeId = runtimeId;
            return this;
        }

        @Generated
        public BlockStateSnapshotBuilder version(int version) {
            this.version = version;
            return this;
        }

        @Generated
        public BlockStateSnapshotBuilder custom(boolean custom) {
            this.custom$value = custom;
            this.custom$set = true;
            return this;
        }

        @Generated
        public BlockStateSnapshotBuilder legacyId(int legacyId) {
            this.legacyId$value = legacyId;
            this.legacyId$set = true;
            return this;
        }

        @Generated
        public BlockStateSnapshotBuilder legacyData(int legacyData) {
            this.legacyData$value = legacyData;
            this.legacyData$set = true;
            return this;
        }

        @Generated
        public BlockStateSnapshotBuilder runtimeIdNetworkProtocol(int runtimeIdNetworkProtocol) {
            this.runtimeIdNetworkProtocol$value = runtimeIdNetworkProtocol;
            this.runtimeIdNetworkProtocol$set = true;
            return this;
        }

        @Generated
        public BlockStateSnapshot build() {
            boolean custom$value = this.custom$value;
            if (!this.custom$set) {
                custom$value = BlockStateSnapshot.$default$custom();
            }
            int legacyId$value = this.legacyId$value;
            if (!this.legacyId$set) {
                legacyId$value = BlockStateSnapshot.$default$legacyId();
            }
            int legacyData$value = this.legacyData$value;
            if (!this.legacyData$set) {
                legacyData$value = BlockStateSnapshot.$default$legacyData();
            }
            int runtimeIdNetworkProtocol$value = this.runtimeIdNetworkProtocol$value;
            if (!this.runtimeIdNetworkProtocol$set) {
                runtimeIdNetworkProtocol$value = BlockStateSnapshot.$default$runtimeIdNetworkProtocol();
            }
            return new BlockStateSnapshot(this.vanillaState, this.runtimeId, this.version, custom$value, legacyId$value, legacyData$value, runtimeIdNetworkProtocol$value);
        }

        @Generated
        public String toString() {
            return "BlockStateSnapshot.BlockStateSnapshotBuilder(vanillaState=" + this.vanillaState + ", runtimeId=" + this.runtimeId + ", version=" + this.version + ", custom$value=" + this.custom$value + ", legacyId$value=" + this.legacyId$value + ", legacyData$value=" + this.legacyData$value + ", runtimeIdNetworkProtocol$value=" + this.runtimeIdNetworkProtocol$value + ")";
        }
    }
}

