/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.leveldb.serializer;

import cn.nukkit.level.format.leveldb.serializer.ChunkSerializer;
import cn.nukkit.level.format.leveldb.serializer.ChunkSerializerV3;
import cn.nukkit.level.format.leveldb.structure.ChunkBuilder;
import cn.nukkit.level.format.leveldb.structure.LevelDBChunk;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.WriteBatch;

public class ChunkSerializers {
    private static final IntObjectMap<ChunkSerializer> SERIALIZERS = new IntObjectHashMap<ChunkSerializer>();

    private static ChunkSerializer getChunkSerializer(int version) {
        ChunkSerializer chunkSerializer = SERIALIZERS.get(version);
        if (chunkSerializer == null) {
            throw new IllegalArgumentException("Invalid chunk serializer version " + version + "! Serializers up to 1.21.30 (version 40) are supported");
        }
        return chunkSerializer;
    }

    public static void serializeChunk(WriteBatch db, LevelDBChunk chunk, int version) {
        ChunkSerializers.getChunkSerializer(version).serialize(db, chunk);
    }

    public static void deserializeChunk(DB db, ChunkBuilder chunkBuilder, int version) {
        ChunkSerializers.getChunkSerializer(version).deserialize(db, chunkBuilder);
    }

    static {
        SERIALIZERS.put(3, ChunkSerializerV3.INSTANCE);
        SERIALIZERS.put(4, ChunkSerializerV3.INSTANCE);
        SERIALIZERS.put(6, ChunkSerializerV3.INSTANCE);
        SERIALIZERS.put(7, ChunkSerializerV3.INSTANCE);
        SERIALIZERS.put(9, ChunkSerializerV3.INSTANCE);
        SERIALIZERS.put(10, ChunkSerializerV3.INSTANCE);
        SERIALIZERS.put(11, ChunkSerializerV3.INSTANCE);
        SERIALIZERS.put(12, ChunkSerializerV3.INSTANCE);
        SERIALIZERS.put(13, ChunkSerializerV3.INSTANCE);
        SERIALIZERS.put(14, ChunkSerializerV3.INSTANCE);
        SERIALIZERS.put(15, ChunkSerializerV3.INSTANCE);
        SERIALIZERS.put(16, ChunkSerializerV3.INSTANCE);
        SERIALIZERS.put(17, ChunkSerializerV3.INSTANCE);
        SERIALIZERS.put(18, ChunkSerializerV3.INSTANCE);
        SERIALIZERS.put(19, ChunkSerializerV3.INSTANCE);
        SERIALIZERS.put(22, ChunkSerializerV3.INSTANCE);
        SERIALIZERS.put(32, ChunkSerializerV3.INSTANCE);
        SERIALIZERS.put(33, ChunkSerializerV3.INSTANCE);
        SERIALIZERS.put(35, ChunkSerializerV3.INSTANCE);
        SERIALIZERS.put(37, ChunkSerializerV3.INSTANCE);
        SERIALIZERS.put(39, ChunkSerializerV3.INSTANCE);
        SERIALIZERS.put(40, ChunkSerializerV3.INSTANCE);
    }
}

