/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.leveldb.serializer;

import cn.nukkit.level.format.leveldb.serializer.ChunkSectionSerializer;
import cn.nukkit.level.format.leveldb.serializer.ChunkSectionSerializerV1;
import cn.nukkit.level.format.leveldb.serializer.ChunkSectionSerializerV7;
import cn.nukkit.level.format.leveldb.serializer.ChunkSectionSerializerV8;
import cn.nukkit.level.format.leveldb.serializer.ChunkSectionSerializerV9;
import cn.nukkit.level.format.leveldb.structure.ChunkBuilder;
import cn.nukkit.level.format.leveldb.structure.StateBlockStorage;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;

public class ChunkSectionSerializers {
    private static final ChunkSectionSerializer[] SERIALIZERS = new ChunkSectionSerializer[10];

    public static void serialize(ByteBuf buf, StateBlockStorage[] storage, int ySection, int version) {
        ChunkSectionSerializers.getSerializer(version).serialize(buf, storage, ySection);
    }

    public static StateBlockStorage[] deserialize(ByteBuf buf, ChunkBuilder builder, int version) {
        return ChunkSectionSerializers.getSerializer(version).deserialize(buf, builder);
    }

    public static ChunkSectionSerializer getSerializer(int version) {
        Preconditions.checkElementIndex(version, SERIALIZERS.length, "Invalid sub-chunk version " + version);
        ChunkSectionSerializer serializer = SERIALIZERS[version];
        if (serializer == null) {
            throw new NullPointerException("No ChunkSectionSerializer for version " + version);
        }
        return serializer;
    }

    static {
        ChunkSectionSerializers.SERIALIZERS[0] = ChunkSectionSerializerV7.INSTANCE;
        ChunkSectionSerializers.SERIALIZERS[1] = ChunkSectionSerializerV1.INSTANCE;
        ChunkSectionSerializers.SERIALIZERS[2] = ChunkSectionSerializerV7.INSTANCE;
        ChunkSectionSerializers.SERIALIZERS[3] = ChunkSectionSerializerV7.INSTANCE;
        ChunkSectionSerializers.SERIALIZERS[4] = ChunkSectionSerializerV7.INSTANCE;
        ChunkSectionSerializers.SERIALIZERS[5] = ChunkSectionSerializerV7.INSTANCE;
        ChunkSectionSerializers.SERIALIZERS[6] = ChunkSectionSerializerV7.INSTANCE;
        ChunkSectionSerializers.SERIALIZERS[7] = ChunkSectionSerializerV7.INSTANCE;
        ChunkSectionSerializers.SERIALIZERS[8] = ChunkSectionSerializerV8.INSTANCE;
        ChunkSectionSerializers.SERIALIZERS[9] = ChunkSectionSerializerV9.INSTANCE;
    }
}

