/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.anvil.util;

import com.google.common.base.Preconditions;
import java.util.Arrays;

public class NibbleArray
implements Cloneable {
    private final byte[] data;

    public NibbleArray(int length) {
        this.data = new byte[length >> 1];
    }

    public NibbleArray(byte[] array) {
        this.data = array;
    }

    public byte get(int index) {
        if (index >= this.data.length << 1) {
            throw new IndexOutOfBoundsException("index=" + index + ", data.length=" + this.data.length);
        }
        byte val = this.data[index >> 1];
        if ((index & 1) == 0) {
            return (byte)(val & 0xF);
        }
        return (byte)((val & 0xF0) >>> 4);
    }

    public void set(int index, byte value) {
        if (value != (value & 0xF)) {
            throw new IllegalArgumentException("Nibbles must have a value between 0 and 15.");
        }
        if (index >= this.data.length << 1 || index < 0) {
            throw new IndexOutOfBoundsException("index=" + index + ", data.length=" + this.data.length);
        }
        value = (byte)(value & 0xF);
        int half = index >> 1;
        byte previous = this.data[half];
        this.data[half] = (index & 1) == 0 ? (byte)(previous & 0xF0 | value) : (byte)(previous & 0xF | value << 4);
    }

    public void remove(int index) {
        if (index >= this.data.length << 1 || index < 0) {
            throw new IndexOutOfBoundsException("index=" + index + ", data.length=" + this.data.length);
        }
        int half = index >> 1;
        byte previous = this.data[half];
        this.data[half] = (index & 1) == 0 ? (byte)(previous & 0xF0) : (byte)(previous & 0xF);
    }

    public void fill(byte value) {
        Preconditions.checkArgument(value >= 0 && value < 16, "Nibbles must have a value between 0 and 15.");
        value = (byte)(value & 0xF);
        Arrays.fill(this.data, (byte)(value << 4 | value));
    }

    public void copyFrom(byte[] bytes) {
        Preconditions.checkNotNull(bytes, "bytes");
        Preconditions.checkArgument(bytes.length == this.data.length, "length of provided byte array is %s but expected %s", bytes.length, this.data.length);
        System.arraycopy(bytes, 0, this.data, 0, this.data.length);
    }

    public void copyFrom(NibbleArray array) {
        Preconditions.checkNotNull(array, "array");
        this.copyFrom(array.data);
    }

    public byte[] getData() {
        return this.data;
    }

    public NibbleArray copy() {
        return new NibbleArray((byte[])this.getData().clone());
    }
}

